% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p-agg.R
\name{cECM_decision}
\alias{cECM_decision}
\title{Decision Function for the C-ECM Model}
\usage{
cECM_decision(pval = NULL, alphatilde = NULL, vic = NULL, cat_truth = NULL)
}
\arguments{
\item{pval}{Class \code{"cECM"} object obtained from providing training and testing data to the \code{\link[=cECM]{cECM()}} function.}

\item{alphatilde}{Scalar numeric between 0 and 1, used as the significance level for hypothesis testing.}

\item{vic}{Character vector of length one, indicating the Very Important Category (VIC).  Used for judging accuracy, false negatives, and false positives for binary categorization.  Required when \code{cat_truth} is supplied.}

\item{cat_truth}{Character vector corresponding to the true group of each row in the \code{newdata} argument, previously provided to the \code{\link[=cECM]{cECM()}} function.  When supplied, along with \code{vic}, binary categorization accuracy is returned.}
}
\value{
When \code{is.null(cat_truth) == TRUE} a vector providing the categorization over all event categories is returned.  When the \code{cat_truth} and \code{vic} arguments are supplied a list is returned containing a \code{data.frame} detailing if each event was categorized accurately in a binary categorization framework, was a false positive, was a false negative, and the estimated event category.  A vector stating overall categorization accuracy, false positive rate, and false negative rate is included with the list.
}
\description{
Returns category decisions for uncategorized events.  When the true category of such events are known performance metrics are returned.
}
\details{
When \code{is.null(cat_truth) == TRUE}, categorization over all event categories is used, using the same framework seen in \insertCite{anderson2007mathematical}{ezECM}.  The return value of \code{"indeterminant"} happens when there is a failure to reject multiple event categories. \code{"undefined"} is returned when all event categories are rejected.

When the arguments \code{cat_truth} and \code{vic} are included, binary categorization is utilized instead of categorization over all training categories.  The definition of accuracy is more ambiguous when categorizing over all training categories and the user is encouraged to develop their own code for such a case.  The goal of binary categorization is to estimate if an uncategorized observation is or is not in the event category stipulated by \code{vic}.  Uncategorized events which are \code{"indeterminant"} or \code{"undefined"} are deemed to not be in the \code{vic} category.
}
\examples{

file_path <- system.file("extdata", "good_training.csv", package = "ezECM")
training_data <- import_pvals(file = file_path, header = TRUE, sep = ",", training = TRUE)

newdata <- training_data[1:10,]
cat_truth <- newdata$event
newdata$event <- NULL
training_data <- training_data[-(1:10),]

pval <- cECM(training_data, transform = TRUE, newdata = newdata)

binary_decision <- cECM_decision(pval = pval, alphatilde = 0.05,
vic = "explosion", cat_truth = cat_truth)

decision <- cECM_decision(pval = pval, alphatilde = 0.05)

}
\references{
\insertAllCited{}
}
