% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwave-depth.R
\name{time_fn}
\alias{time_fn}
\title{P-wave arrival times simulation}
\usage{
time_fn(X = NULL, X0 = NULL, V = 7)
}
\arguments{
\item{X}{numeric three element vector stipulating the location of a seismometer.  Units of km}

\item{X0}{numeric three element vector stipulating the location of an event.  Units of km}

\item{V}{numeric scalar supplying the p-wave velocity in km/s.  A quick google search (Jan 31st 2023) shows typical values range from 5 to 8 km/s.}
}
\value{
numeric scalar providing the time in seconds for a p-wave to arrive at a seismometer.
}
\description{
Simulates the arrival time of p-waves (without noise) using a mean velocity and euclidian distance, without taking the curvature into account.
}
\details{
Used for estimating event location, given a series of seismometer observations.
}
\examples{
  arrival.time <- time_fn(X = c(100,200,10), X0  = c(500, 80, 25), V = 5)

}
