% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuisance_regression.R
\name{nuisance_regression}
\alias{nuisance_regression}
\title{Nuisance regression}
\usage{
nuisance_regression(Y, design)
}
\arguments{
\item{Y}{The \eqn{T \times V} or \eqn{V \times T} data.}

\item{design}{The \eqn{T \times Q} matrix of nuisance regressors.}
}
\value{
The data after nuisance regression.
}
\description{
Performs nuisance regression. Important note: the data and design matrix must
both be centered, or an intercept must be included in the design matrix.
}
\examples{
Y <- matrix(rnorm(700), nrow=100)
design <- cbind(seq(100), 1)
nuisance_regression(Y, design)
}
