% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabzCI.R
\name{fabzCI}
\alias{fabzCI}
\title{FAB z-interval}
\usage{
fabzCI(y, mu, t2, s2, alpha = 0.05)
}
\arguments{
\item{y}{a numeric scalar}

\item{mu}{a numeric scalar}

\item{t2}{a positive numeric scalar}

\item{s2}{a positive numeric scalar}

\item{alpha}{the type I error rate, so 1-alpha is the coverage rate}
}
\description{
Computation of a 1-alpha FAB z-interval
}
\details{
A FAB interval is the "frequentist" interval procedure
that is Bayes optimal: It  minimizes the prior expected
interval width among all interval procedures with 
exact 1-alpha frequentist coverage. This function computes 
the FAB z-interval for the mean of a normal population with an 
known variance, given a user-specified prior distribution 
determined by \code{psi}. The prior is that the population mean 
is normally distributed. 
Referring to the elements of \code{psi}
as mu, t2, s2, the prior and population variance are
determined as follows:
\enumerate{
\item mu is the prior expectation of the mean
\item t2 is the prior variance of the  mean
\item s2 is the population variance
}
}
\examples{
y<-0
fabzCI(y,0,10,1)
fabzCI(y,0,1/10,1)
fabzCI(y,2,10,1)
fabzCI(y,0,1/10,1) 

}
\author{
Peter Hoff
}
\keyword{htest}

