% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dates.R
\name{which_any_date}
\alias{which_any_date}
\title{Evaluates and gives the possible format(s) for an object to be evaluated}
\usage{
which_any_date(
  x,
  format = c("ymd", "ydm", "dmy", "myd", "mdy", "dym", "my", "ym", "as_date")
)
}
\arguments{
\item{x}{object to be coerced. Can be a character string or a vector.}

\item{format}{A character identifying the format to apply to the object to
test.
That format can be 'ymd','ydm','dmy','myd','mdy','dym', 'ym', 'my' or
'as_date' in that specific order ('ymd" will be chose as a default format,
then 'ymd', etc.).}
}
\value{
A character string of the possible date formats given a parameter to be
tested. The length of the vector is the length of the input object.
}
\description{
This function takes a character string or a vector. This vector is evaluates
one observation after the other, and gives the best matching date format
for each of them (independently). The best matching format is tested across
seven different formats provided by the lubridate library. The information of
the best matching format can be used to mutate a column using
\code{\link[=as_any_date]{as_any_date()}}.
}
\details{
Contrary to lubridate library or \code{\link[=as.Date]{as.Date()}}, the function evaluates
the different possibilities for a date. For example, c('02-03-1982') can be
either March the 2nd or February the 3rd. The function will provide
"mdy, dmy" as possible formats. If no format is found, the function returns
NA.
}
\examples{
{

time <- c(
  "1983-07-19",
  "31 jan 2017",
  "1988/12/17",
  "31-02-05",
  "02-02-02",
  "2017 october the 2nd",
  "02-07-2012",
  "19-07-83",
  "19-19-19")

which_any_date(time)

}

}
\seealso{
\code{\link[lubridate:ymd]{lubridate::ymd()}},\code{\link[lubridate:ymd]{lubridate::ydm()}},\code{\link[lubridate:ymd]{lubridate::dmy()}},
\code{\link[lubridate:ymd]{lubridate::myd()}},\code{\link[lubridate:ymd]{lubridate::mdy()}},\code{\link[lubridate:ymd]{lubridate::dym()}},
\code{\link[lubridate:ymd]{lubridate::my()}} ,\code{\link[lubridate:ymd]{lubridate::ym()}},
\code{\link[lubridate:as_date]{lubridate::as_date()}},\code{\link[=as.Date]{as.Date()}},
\code{\link[=guess_date_format]{guess_date_format()}},\code{\link[=as_any_date]{as_any_date()}}
}
