% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INGARCH.R
\name{forecast.INGARCH}
\alias{forecast.INGARCH}
\title{Forecast a model from the fable package}
\usage{
\method{forecast}{INGARCH}(object, new_data, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{new_data}{Tsibble, it has to contains the time points and exogenous regressors to produce forecasts for.}

\item{...}{Other arguments passed to methods}
}
\value{
A list of forecasts.
}
\description{
Produces forecasts from a trained model.
}
\details{
Predict future observations based on a fitted GLM-type model for time series of counts.
For 1 step ahead, it returns parametric forecast, based on the 'distr' param especified distribution,
for multiples steps forecast, the distribution is not know analytically, so it uses a parametric bootstrap
}
\examples{
 # 1 step ahead parametric forecast
tsibbledata::aus_production |>
  fabletools::model(manual_ing = INGARCH(Beer ~ pq(1,1) + PQ(1,1))) |>
  dplyr::select(manual_ing) |>
  fabletools::forecast(h = 1)

# Multiples steap ahead parametric bootstrap forecast
tsibbledata::aus_production |>
  fabletools::model(manual_ing = INGARCH(Beer ~ pq(1,1) + PQ(1,1))) |>
  dplyr::select(manual_ing) |>
  fabletools::forecast(h = 4)

}
