% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv_finite_factorial.R
\name{iv_finite_factorial}
\alias{iv_finite_factorial}
\title{Finite-Sample IV Estimation of 2^K Factorial Design}
\usage{
iv_finite_factorial(formula, data, subset, level = 0.95)
}
\arguments{
\item{formula}{formula specification of the factorial design with
noncompliance. The right-hand side of the formula should have
two components separated by the \code{|} symbol, with the first
component containing the K binary treatment variables and the
second component containing the K binary instruments associated
with each treatment variable. The order of the variables in the
formula must match.}

\item{data}{a data.frame on which to apply the \code{formula}.}

\item{subset}{subset of the data to pass to estimation.}

\item{level}{the confidence level required.}
}
\value{
A list of class \code{iv_finite_factorial} that contains the
following components:
\item{tau}{a vector of estimated effect ratios for each factor.}
\item{tau_cis}{a matrix of confidence intervals for each effect
ratio. This matrix has 4 columns because it is possible to have
disjoint confidence intervals in this method.}
\item{tau_y}{a vector of the estimated effects on the outcome.}
\item{v_tau_y}{the estimated sample variances of the effects on
the outcome.}
\item{tau_d}{a vector of the estimated effects on treatment
uptake.}
\item{v_tau_y}{the estimated sample variances of the effects on
treatment uptake.}
\item{level}{the confidence level of \code{tau_cis}.}
}
\description{
Estimate main effect IV ratios for 2^K factorial experiments
}
\details{
This function estimates the ratio of the effect of treatment
assignment on the outcome to the effect of treatment assignment on
treatment uptake in 2^K factorial experiments. The approach uses
finite sample asymptotic inference to generate confidence
intervals.
}
\examples{
data(newhaven)

out <- iv_finite_factorial(turnout_98 ~ inperson + phone | inperson_rand
  + phone_rand, data = newhaven)

out

joint <- iv_finite_factorial(turnout_98 ~ inperson + phone |
  inperson_rand + phone_rand, data = newhaven)

joint

}
\references{
Matthew Blackwell and Nicole Pashley (2021) "Noncompliance in
Factorial Experiments." Working paper.
}
\author{
Matt Blackwell
}
