% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strLgrkPower.R
\name{strLgrkPower}
\alias{strLgrkPower}
\title{Stratified (overall) logrank power}
\usage{
strLgrkPower(n, hrA, hrB, hrAB, avgprob, dig = 2, alpha = 0.05)
}
\arguments{
\item{n}{total subjects with n/4 subjects in the C, A, B, and AB groups}

\item{hrA}{group A to group C hazard ratio}

\item{hrB}{group B to group C hazard ratio}

\item{hrAB}{group AB to group C hazard ratio}

\item{avgprob}{average event probability across the four groups as
calculated by the function eventProb}

\item{dig}{number of decimal places to which we \code{\link{roundDown}} the critical value
corresponding to \code{alpha}}

\item{alpha}{two-sided significance level}
}
\value{
\item{mean}{logrank mean value}

\item{power}{logrank power}

\item{nevent}{expected number of events}
}
\description{
Computes the power for the overall treatment A effect based on the stratified logrank test
 based on Slud (1994).
}
\details{
The \code{roundDown} function is used in conjunction with the \code{dig} argument
to insure that any rounding of the (negative) critical values will be done conservatively to control
the familywise type I error at the desired level.
}
\examples{
rateC <- 0.0445
hrA <- 0.80
hrB <- 0.80
hrAB <- 0.72
mincens <- 4.0
maxcens <- 8.4
avgprob <- eventProb(rateC, hrA, hrB, hrAB, mincens, maxcens)$avgprob
n <- 4600
strLgrkPower(n, hrA, hrB, hrAB, avgprob, dig = 2, alpha = 0.05)
# $mean
# [1] -2.537779

# $power
# [1] 0.7182932

# $nevent
# [1] 954.8738
}
\references{
Leifer, E.S., Troendle, J.F., Kolecki, A., Follmann, D. Joint testing of overall and
simple effect for the two-by-two factorial design. (2019). Submitted.

Slud, E.V. Analysis of factorial survival experiments. Biometrics. 1994; 50: 25-38.
}
\seealso{
\code{\link{roundDown}},  \code{\link{eventProb}}
}
\author{
Eric Leifer, James Troendle
}
