% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{proc_align3}
\alias{proc_align3}
\title{Procrustes alignment for 3-mode tensors}
\usage{
proc_align3(A,B,return_orth=FALSE)
}
\arguments{
\item{A}{An \eqn{n \times d \times m} array.}

\item{B}{An \eqn{n \times d \times m} array.}

\item{return_orth}{A Boolean which specifies whether to return the
orthogonal transformation.
Defaults to \code{FALSE}.}
}
\value{
If \code{return_orth} is \code{FALSE}, returns the \eqn{n \times d \times m}
array resulting from applying the optimal aligning transformation to
the columns of the \eqn{n \times d} slices of \code{A}.
Otherwise, returns a list with two entries:
\item{Ao}{The \eqn{n \times d}
matrix resulting from applying the optimal aligning transformation to the
columns of the \eqn{n \times d} slices of \code{A}.}
\item{orth}{The \eqn{d \times d} optimal aligning orthogonal transformation matrix.}
}
\description{
\code{proc_align3} applies one orthogonal transformation
to the columns of each of the \eqn{n \times d} slices of an
\eqn{n \times d \times m} array \eqn{A} to
find the best approximation (in terms of matrix Frobenius norm, averaged
over the  \eqn{n \times d} slices) to a
second \eqn{n \times d \times m} array \eqn{B}.
Optionally, it may also return the optimal transformation
matrix.
}
