% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastOnlineCpt.r
\docType{methods}
\name{resetAlgorithm}
\alias{resetAlgorithm}
\alias{resetAlgorithm,fastOnlineCpt-method}
\title{Reset the algorithm in order to detect a new changepoint. The algorithm can be reset at any point in time. To ensure valid multiple testing corrections, the time horizon is not reset to zero.}
\usage{
resetAlgorithm(obj)

\S4method{resetAlgorithm}{fastOnlineCpt}(obj)
}
\arguments{
\item{obj}{An object of the class "fastOnlineCpt".}
}
\value{
An object of the class "fastOnlineCpt".
}
\description{
Reset the algorithm in order to detect a new changepoint. The algorithm can be reset at any point in time. To ensure valid multiple testing corrections, the time horizon is not reset to zero.
}
\examples{
library(fastOnlineCpt)
alpha <- 0.01
halfspent <- 100
spending_sequence <- function(n) { (n/(n+halfspent) - (n-1)/(n-1+halfspent)) * alpha }
obj <- fastOnlineCpt(spending_sequence)
p <- 10
n <- 50
data <- matrix(rnorm(p*n,mean=0),ncol=n)
obj <- addData(obj,data)
obj <- resetAlgorithm(obj)

}
\references{
Hahn, G. (2021). Online multivariate changepoint detection with type I error control and constant time/memory updates per series. Under review.
}
