% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kqr-methods.R
\name{predict.kqr}
\alias{predict.kqr}
\title{Predict the fitted values for a \code{kqr} object.}
\usage{
\method{predict}{kqr}(object, x, newx = NULL, s = NULL, ...)
}
\arguments{
\item{object}{A fitted \code{kqr} object.}

\item{x}{The predictor matrix, i.e., the \code{x} matrix used when fitting the \code{kqr} object.}

\item{newx}{A matrix of new values for \code{x} at which predictions are to be made. Note
that \code{newx} must be of a matrix form, predict function does not accept a vector or other
formats of \code{newx}.}

\item{s}{Value(s) of the penalty parameter `lambda` at which
predictions are required. Default is the entire sequence used to create the
model.}

\item{...}{Not used.}
}
\value{
Returns the fitted values.
}
\description{
Predict the fitted values for a \code{kqr} object.
}
\details{
The result is \eqn{\beta_0 + K_i' \alpha} where \eqn{\beta_0} and \eqn{\alpha} are from the
\code{kqr} object and \eqn{K_i} is the ith row of the kernel matrix.
}
\examples{
library(MASS)
data(GAGurine)
x <- as.matrix(GAGurine$Age)
y <- GAGurine$GAG
lambda <- 10^(seq(1, -4, length.out=30))
fit <- kqr(x, y, lambda=lambda, tau=0.1, is_exact=TRUE)
predict(fit, x, tail(x))
}
\keyword{classification}
\keyword{kernel}
