% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_plot_collection.R
\name{qc_plot_collection}
\alias{qc_plot_collection}
\title{Plot FastQC Results of multiple samples}
\usage{
qc_plot_collection(qc, modules = "all")
}
\arguments{
\item{qc}{An object of class qc_read_collection or a path to the sample zipped fastqc result files.}

\item{modules}{Character vector containing the names of fastqc modules for
  which you want to import the data. Default is all. Allowed values include
  one or the combination of:
  \itemize{
  \item "Summary",
   \item "Basic Statistics",
   \item "Per base sequence quality",
   \item "Per sequence quality scores",
   \item "Per base sequence content",
   \item "Per sequence GC content",
   \item "Per base N content",
   \item "Sequence Length Distribution",
   \item "Sequence Duplication Levels",
   \item "Overrepresented sequences",
   \item "Adapter Content",
   \item "Kmer Content"
  }
Partial match of module names allowed. For example,
you can use modules = "GC content", instead of the full names modules = "Per sequence GC content".}
}
\value{
Returns a list of ggplots containing the plot for specified modules..
}
\description{
Plot FastQC data of multiple samples
}
\examples{
qc.dir <- system.file("fastqc_results", package = "fastqcr")
qc.files <- list.files(qc.dir, full.names = TRUE)[1:2]
nb_samples <- length(qc.files)

# read specific modules in all files
# To read all modules, specify: modules = "all"
modules <- c(
  "Per sequence GC content",
  "Per base sequence quality",
 "Per sequence quality scores"
)
qc <- qc_read_collection(qc.files, sample_names = paste('S', 1:nb_samples, sep = ''),
       modules = modules)

# Plot per sequence GC content
qc_plot_collection(qc, "Per sequence GC content")

# Per base sequence quality
qc_plot_collection(qc, "Per base sequence quality")

# Per sequence quality scores
qc_plot_collection(qc, "Per sequence quality scores")


}
\author{
Mahmoud Ahmed, \email{mahmoud.s.fahmy@students.kasralainy.edu.eg}
}
