% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrs.fast.bt.r
\name{qrs.fast.bt}
\alias{qrs.fast.bt}
\title{qrs.fast.bt}
\usage{
qrs.fast.bt(
  y,
  x,
  d,
  z,
  w0 = NULL,
  Q1,
  Q2,
  P = 10,
  link,
  family,
  gridtheta,
  m,
  b0,
  reps,
  alpha
)
}
\arguments{
\item{y}{= Dependent variable (N x 1)}

\item{x}{= Regressors matrix (N x K)}

\item{d}{= Participation variable (N x 1)}

\item{z}{= Regressors and instruments matrix for the propensity score
(N x Kz)}

\item{w0}{= Sample weights (N x 1)}

\item{Q1}{= Number of quantiles in reduced grid}

\item{Q2}{= Number of quantiles in large grid}

\item{P}{=  Number of evaluated values of parameter with large quantile
grid}

\item{link}{= Link function to compute the propensity score}

\item{family}{= Parametric copula family}

\item{gridtheta}{= Grid of values for copula parameter (T x 1)}

\item{m}{=  Parameter to select interval of observations in top and bottom
groups}

\item{b0}{= Initial values of the beta coefficients for all quantiles in
the reduced quantile grid (K x Q1)}

\item{reps}{= Number of bootstrap repetitions}

\item{alpha}{= Significance level}
}
\value{
gammase = Bootstrapped standard error of gamma coefficients
(Kz x 1)

gammaub = Bootstrapped upper bound of confidence interval of gamma
coefficients (Kz x 1)

gammalb = Bootstrapped lower bound of confidence interval of gamma
coefficients (Kz x 1)

betase = Bootstrapped standard error of beta coefficients (K x Q)

betaub = Bootstrapped upper bound of confidence interval of beta
coefficients (K x Q)

betalb = Bootstrapped lower bound of confidence interval of beta
coefficients (K x Q)

thetase = Bootstrapped standard error of theta coefficients
(1 x 1)

thetaub = Bootstrapped upper bound of confidence interval of theta
coefficients (1 x 1)

thetalb = Bootstrapped lower bound of confidence interval of theta
coefficients (1 x 1)

gamma = Bootstrapped estimated theta coefficients (Kz x reps)

beta = Bootstrapped estimated beta coefficients (K x Q2 x reps)

theta = Bootstrapped estimated copula parameter (1 x reps)

objf = Bootstrapped value of objective function at the optimum
(1 x reps)
}
\description{
Algorithm 4: bootstrap algorithm with preprocessing and quantile grid
reduction for Quantile Regression with Selection (QRS).
}
\examples{
\donttest{
set.seed(1)
N <- 100
x <- cbind(1, 2 + runif(N))
z <- cbind(x, runif(N))
cop <- copula::normalCopula(param = -0.5, dim = 2)
copu <- copula::rCopula(N, cop)
v <- copu[,1]
u <- copu[,2]
gamma <- c(-1.5, 0.05, 2)
beta <- cbind(qnorm(u), u^0.5)
prop <- exp(z \%*\% gamma) / (1 + exp(z \%*\% gamma))
d <- as.numeric(v <= prop)
y <- d * rowSums(x * beta)
w <- matrix(1, nrow = N, ncol = 1)

Q1 <- 9
Q2 <- 19
P <- 2
m <- 1
gridtheta <- seq(-1, 0, by = 0.1)
link <- "probit"
family <- "Gaussian"
reps <- 10
alpha <- 0.05

est <- qrs.fast(y, x[,-1], d, z[,-1], w, Q1, Q2, P, link, family, gridtheta, m)
bt <- qrs.fast.bt(y, x[,-1], d, z[,-1], w, Q1, Q2, P, link, family,
                  gridtheta, m, est$b1, reps, alpha)
summary(bt)
}
}
