% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{ft_level_stats}
\alias{ft_level_stats}
\title{Calculate Statistics for Each Factor Level}
\usage{
ft_level_stats(factor_vec, numeric_vec, stat_func)
}
\arguments{
\item{factor_vec}{A factor vector.}

\item{numeric_vec}{A numeric vector of the same length as \code{factor_vec}.}

\item{stat_func}{A function to compute the statistic (e.g., mean, median).}
}
\value{
A data frame with factor levels and their corresponding statistics.
}
\description{
Computes statistical summaries for each level of a factor vector based on associated numeric data.
}
\examples{
# Example data
factor_vec <- factor(c('A', 'B', 'A', 'B', 'C'))
numeric_vec <- c(10, 20, 15, 25, 30)

# Calculate mean for each level
ft_level_stats(factor_vec, numeric_vec, stat_func = mean)
}
\author{
Kai Guo
}
