% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{ft_regex_freq}
\alias{ft_regex_freq}
\title{Reorder Factor Levels Based on Regex Pattern Frequency}
\usage{
ft_regex_freq(
  factor_vec,
  pattern,
  case = FALSE,
  decreasing = TRUE,
  inplace = TRUE
)
}
\arguments{
\item{factor_vec}{A factor vector whose levels are to be reordered.}

\item{pattern}{A string representing the regular expression pattern to match.}

\item{case}{Logical. Should the pattern matching be case-sensitive? Default is \code{FALSE}.}

\item{decreasing}{Logical. Should the ordering be decreasing by frequency? Default is \code{TRUE}.}

\item{inplace}{Logical. If \code{TRUE}, returns a new factor vector with elements reordered to align with the new levels' order. If \code{FALSE}, returns a new factor vector with only the levels' order adjusted, leaving the data vector's elements' order unchanged. Defaults to \code{FALSE}.}
}
\value{
A factor vector with levels reordered based on the frequency of matched substrings.
}
\description{
Reorders the levels of a factor vector based on the frequency of substrings matching a regular expression.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'apricot', 'cherry', 'blueberry', 'blackberry', 'date'))

# Reorder based on pattern matching 'a'
ft_regex_freq(factor_vec, pattern = 'a')

# Reorder with case-sensitive matching
ft_regex_freq(factor_vec, pattern = '^[A-Z]', case = TRUE)
}
\author{
Kai Guo
}
