% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata2pc.R
\name{P.penalty}
\alias{P.penalty}
\title{Penalty matrix for higher order differences}
\usage{
P.penalty(tt, P = c(0, 0, 1))
}
\arguments{
\item{tt}{vector of the \code{n} discretization points or argvals.}

\item{P}{vector of coefficients with the order of the differences. Default
value \code{P}=c(0,0,1) penalizes the second order difference.}
}
\value{
penalty matrix of size \code{sum(n)} x \code{sum(n)}
}
\description{
This function computes the matrix that penalizes the higher order
differences.
}
\details{
For example, if \code{P}=c(0,1,2), the function return the penalty matrix
the second order difference of a vector \eqn{tt}. That is \deqn{v^T P_j tt=
\sum_{i=3} ^{n} (\Delta tt_i) ^2} where \deqn{\Delta tt_i= tt_i -2 tt_{i-1}
+ tt_{i-2}} is the second order difference. More details can be found in
Kraemer, Boulesteix, and Tutz (2008).
}
\note{
The discretization points can be equidistant or not.
}
\examples{

P.penalty((1:10)/10,P=c(0,0,1))
# a more detailed example can be found under script file 
}
\references{
N. Kraemer, A.-L. Boulsteix, and G. Tutz (2008). \emph{Penalized
Partial Least Squares with Applications to B-Spline Transformations and
Functional Data}. Chemometrics and Intelligent Laboratory Systems, 94, 60 -
69. \doi{10.1016/j.chemolab.2008.06.009}
}
\seealso{
\code{\link{fdata2pls}}
}
\author{
This version is created by Manuel Oviedo de la Fuente modified the
original version created by Nicole Kramer in \code{ppls} package.
}
\keyword{math}
