% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth.mdata.R
\name{depth.mdata}
\alias{depth.mdata}
\alias{mdepth.LD}
\alias{Depth.Multivariate}
\alias{mdepth.FM}
\alias{mdepth.HS}
\alias{mdepth.MhD}
\alias{mdepth.SD}
\alias{mdepth.TD}
\alias{mdepth.RP}
\alias{mdepth.FSD}
\alias{mdepth.KFSD}
\title{Provides the depth measure for multivariate data}
\usage{
mdepth.LD(x, xx = x, metric = metric.dist, h = NULL, scale = FALSE, ...)

mdepth.HS(x, xx = x, proj = 50, scale = FALSE, xeps = 1e-15, random = FALSE)

mdepth.RP(x, xx = x, proj = 50, scale = FALSE)

mdepth.MhD(x, xx = x, scale = FALSE)

mdepth.KFSD(x, xx = x, trim = 0.25, h = NULL, scale = FALSE, draw = FALSE)

mdepth.FSD(x, xx = x, trim = 0.25, scale = FALSE, draw = FALSE)

mdepth.FM(x, xx = x, scale = FALSE, dfunc = "TD1")

mdepth.TD(x, xx = x, xeps = 1e-15, scale = FALSE)

mdepth.SD(x, xx = NULL, scale = FALSE)
}
\arguments{
\item{x}{is a set of points, a d-column matrix.}

\item{xx}{is a d-dimension multivariate reference sample (a d-column matrix)
where \code{x} points are evaluated.}

\item{metric}{Metric function, by default \code{\link{metric.dist}}.
Distance matrix between \code{x} and \code{xx} is computed.}

\item{h}{Bandwidth, \code{h>0}. Default argument values are provided as the
15\%--quantile of the distance between \code{x} and \code{xx}.}

\item{scale}{=TRUE, scale the depth, see \link[base]{scale}.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{proj}{are the directions for random projections, by default 500 random
projections generated from a scaled \code{runif(500,-1,1)}.}

\item{xeps}{Accuracy. The left limit of the empirical distribution function.}

\item{random}{=TRUE for random projections. =FALSE for deterministic
projections.}

\item{trim}{The alpha of the trimming.}

\item{draw}{=TRUE, draw the curves, the sample median and trimmed mean.}

\item{dfunc}{type of univariate depth function used inside depth function:
"FM1" refers to the original Fraiman and Muniz univariate depth (default),
"TD1" Tukey (Halfspace),"Liu1" for simplical depth, "LD1" for Likelihood
depth and "MhD1" for Mahalanobis 1D depth. Also, any user function
fulfilling the following pattern \code{FUN.USER(x,xx,...)} and returning a
\code{dep} component can be included.}
}
\value{
\itemize{ 
\item \code{lmed}: Index of the deepest element (median) of \code{xx}.
\item \code{ltrim}: Index of the set of points \code{x} with trimmed mean \code{mtrim}. 
\item \code{dep}: Depth of each point in \code{x} with respect to \code{xx}.
\item \code{proj}: The projection value of each point onto the set of points.
\item \code{x}: A set of points to be evaluated.
\item \code{xx}: A reference sample.
\item \code{name}: Name of the depth method.
}
}
\description{
Compute measure of centrality of the multivariate data. Type of depth
function: simplicial depth (SD), Mahalanobis depth (MhD), Random Half--Space
depth (HS), random projection depth (RP) and Likelihood Depth (LD).
}
\details{
Type of depth measures:
\itemize{ 
\item The \code{\link{mdepth.SD}} calculates the simplicial depth (HD) of the points in \code{x} w.r.t.
\code{xx} (for bivariate data).  
\item The \code{\link{mdepth.HS}} function calculates the random half--space depth (HS)
 of the points in \code{x} w.r.t. \code{xx} based on random projections \code{proj}.  
\item The \code{\link{mdepth.MhD}} function calculates the Mahalanobis depth (MhD)
 of the points in \code{x} w.r.t. \code{xx}.  
\item The \code{\link{mdepth.RP}} calculates the random' projection depth (RP) 
 of the points in \code{x} w.r.t. \code{xx} based on random projections \code{proj}.
\item The \code{\link{mdepth.LD}} calculates the Likelihood depth (LD) of the points 
in \code{x} w.r.t. \code{xx}.  
\item The \code{\link{mdepth.TD}} function provides the Tukey depth measure for multivariate data.
}
}
\examples{
\dontrun{
data(iris)
group<-iris[,5]
x<-iris[,1:2]
                                  
MhD<-mdepth.MhD(x)
PD<-mdepth.RP(x)
HD<-mdepth.HS(x)
SD<-mdepth.SD(x)

x.setosa<-x[group=="setosa",]
x.versicolor<-x[group=="versicolor",] 
x.virginica<-x[group=="virginica",]
d1<-mdepth.SD(x,x.setosa)$dep
d2<-mdepth.SD(x,x.versicolor)$dep
d3<-mdepth.SD(x,x.virginica)$dep
}
}
\references{
Liu, R. Y., Parelius, J. M., and Singh, K. (1999). Multivariate
analysis by data depth: descriptive statistics, graphics and inference,(with
discussion and a rejoinder by Liu and Singh). \emph{The Annals of
Statistics}, 27(3), 783-858.
}
\seealso{
Functional depth functions: \code{\link{depth.FM}},
\code{\link{depth.mode}}, \code{\link{depth.RP}}, \code{\link{depth.RPD}}
and \code{\link{depth.RT}}.
}
\author{
\code{\link{mdepth.RP}}, \code{\link{mdepth.MhD}} and
\code{\link{mdepth.HS}} are versions created by Manuel Febrero Bande and
Manuel Oviedo de la Fuente of the original version created by Jun Li, Juan
A. Cuesta Albertos and Regina Y. Liu for polynomial classifier.
}
\keyword{descriptive}
