% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_autocorrelation.R
\name{obtain_FPACF}
\alias{obtain_FPACF}
\title{Obtain the partial autocorrelation function for a given FTS.}
\usage{
obtain_FPACF(Y, v, nlags, n_harm, ci = 0.95, estimation = "MC",
  figure = TRUE, ...)
}
\arguments{
\item{Y}{Matrix containing the discretized values
of the functional time series. The dimension of the
matrix is \eqn{(n x m)}, where \eqn{n} is the
number of curves and \eqn{m} is the number of points
observed in each curve.}

\item{v}{Discretization points of the curves.}

\item{nlags}{Number of lagged covariance operators
of the functional time series that will be used
to estimate the partial autocorrelation function.}

\item{n_harm}{Number of principal components
that will be used to fit the ARH(p) models.}

\item{ci}{A value between 0 and 1 that indicates
the confidence interval for the i.i.d. bounds
of the partial autocorrelation function. By default
\code{ci = 0.95}.}

\item{estimation}{Character specifying the
method to be used when estimating the distribution
under the hypothesis of functional white noise.
Accepted values are:
\itemize{
   \item "MC": Monte-Carlo estimation.
   \item "Imhof": Estimation using Imhof's method.
}
By default, \code{estimation = "MC"}.}

\item{figure}{Logical. If \code{TRUE}, plots the
estimated partial autocorrelation function with the
specified i.i.d. bound.}

\item{...}{Further arguments passed to the \code{plot_FACF}
function.}
}
\value{
Return a list with:
\itemize{
    \item \code{Blueline}: The upper prediction
    bound for the i.i.d. distribution.
    \item \code{rho}: Partial autocorrelation
    coefficients for
    each lag of the functional time series.
}
}
\description{
Estimate the partial autocorrelation
function for a given functional time series and its
distribution under the hypothesis of strong functional
white noise.
}
\examples{
# Example 1

N <- 100
v <- seq(from = 0, to = 1, length.out = 5)
sig <- 2
set.seed(15)
Y <- simulate_iid_brownian_bridge(N, v, sig)
obtain_FPACF(Y,v,10, n_harm = 2)

\donttest{
# Example 2

data(elec_prices)
v <- seq(from = 1, to = 24)
nlags <- 30
obtain_FPACF(Y = as.matrix(elec_prices), 
v = v,
nlags = nlags,
n_harm = 5, 
ci = 0.95,
figure = TRUE)
}
}
\references{
Mestre G., Portela J., Rice G., Muñoz San Roque A., Alonso E. (2021).
\emph{Functional time series model identification and diagnosis by 
means of auto- and partial autocorrelation analysis.}
Computational Statistics & Data Analysis, 155, 107108.
\url{https://doi.org/10.1016/j.csda.2020.107108}
}
