% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_autocovariance}
\alias{plot_autocovariance}
\title{Generate a 3D plot of the autocovariance surface of a given FTS}
\usage{
plot_autocovariance(fun.autocovariance, lag = 0, ...)
}
\arguments{
\item{fun.autocovariance}{A list obtained by
calling the function \code{obtain_autocovariance}.}

\item{lag}{An integer between 0 and \code{nlags}, indicating
the lagged autocovariance function to be plotted.
By default 0.}

\item{...}{Further arguments passed to the  \code{persp}
function.}
}
\description{
Obtain a 3D plot of the autocovariance surfaces of a
given functional time series. This visualization is
useful to detect any kind of dependency between
the discretization points of the series.
}
\examples{
# Example 1

N <- 100
v <- seq(from = 0, to = 1, length.out = 10)
sig <- 2
bbridge <- simulate_iid_brownian_bridge(N, v, sig)
nlags <- 1
lagged_autocov <- obtain_autocovariance(Y = bbridge,nlags = nlags)
plot_autocovariance(lagged_autocov,1)

\donttest{
# Example 2

N <- 500
v <- seq(from = 0, to = 1, length.out = 50)
sig <- 2
bbridge <- simulate_iid_brownian_bridge(N, v, sig)
nlags <- 4
lagged_autocov <- obtain_autocovariance(Y = bbridge,nlags = nlags)
opar <- par(no.readonly = TRUE)
par(mfrow = c(1,5))
for(k in 0:nlags){
   plot_autocovariance(lagged_autocov,k)
}
par(opar)
}
}
