#' fdaconcur: Concurrent Regression and History Index Models for Functional Data
#'
#' fdaconcur for Functional Concurrent Regression and History Index Models
#'
#' Provides an implementation of concurrent or varying coefficient regression methods for
#' functional data. The implementations are done for both dense and sparsely observed functional
#' data. Pointwise confidence bands can be constructed for each case. Further, the influence of
#' past predictor values are modeled by a smooth history index function,
#' while the effects on the response are described by smooth varying coefficient functions,
#' which are very useful in analyzing real data such as COVID data.
#'
#' References: Yao, F., Müller, H.G., Wang, J.L. (2005) <doi: 10.1214/009053605000000660>.
#' Sentürk, D., Müller, H.G. (2010) <doi: 10.1198/jasa.2010.tm09228>.
#'
#'
#' PACE is based on the idea that observed functional data
#' are generated by a sample of underlying (but usually not fully
#' observed) random trajectories that are realizations of a stochastic process. It does not rely on pre-smoothing of
#' trajectories, which is problematic if functional data are sparsely sampled.
#'
#' Maintainer:  Su I Iao \email{siao@@ucdavis.edu}
#'
#' @author
#' Satarupa Bhattacharjee
#' Yaqing Chen
#' Changbo Zhu
#' Han Chen
#' Yidong Zhou
#' Álvaro Gajardo
#' Poorbita Kundu
#' Hang Zhou
#'
#' Hans-Georg Müller \email{hgmueller@@ucdavis.edu}
#'
#' @description This package provides tools for functional concurrent regression and history index models.
#' @name fdaconcur
#' @useDynLib fdaconcur
#' @import Rcpp
"_PACKAGE"
