% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fermicatsR.R
\docType{data}
\name{DF1}
\alias{DF1}
\title{1DF Catalog (First D3PO Fermi catalog of gamma-ray source candidates)}
\format{A data frame with 48 variables on 3106 gamma-ray sources.}
\source{
\url{http://wwwmpa.mpa-garching.mpg.de/ift/fermi/}
}
\usage{
DF1
}
\description{
The Denoised, Deconvolved, and Decomposed Fermi Gamma-ray Sky: An application of the D3PO algorithm
Selig, M. et al., Astronomy and Astrophysics, 581, 126 (2015).
}
\details{
FITS Filename: catalog_1.fits
}
\section{Fields}{
 
\describe{
\item{CandidateName}{Candidate Name}
\item{GLON}{Galactic Longitude, deg.}
\item{GLAT}{Galactic Latitude, deg.}
\item{Flux}{Total flux between 1-100 GeV, photon cm^{-2} s^{-1}}
\item{Emid1}{Contributing energy band 1, T/F, Emin=0.60 GeV, Emid=0.85 GeV, Max=1.20 GeV}
\item{Emid2}{Contributing energy band 2, T/F, Emin=1.20 GeV, Emid=1.70 GeV, Max=2.40 GeV}
\item{Emid3}{Contributing energy band 3, T/F, Emin=2.40 GeV, Emid=3.40 GeV, Max=4.80 GeV}
\item{Emid4}{Contributing energy band 4, T/F, Emin=4.80 GeV, Emid=6.79 GeV, Max=9.60 GeV}
\item{Emid5}{Contributing energy band 5, T/F, Emin=9.60 GeV, Emid=13.58 GeV, Max=19.20 GeV}
\item{Emid6}{Contributing energy band 6, T/F, Emin=19.20 GeV, Emid=27.15 GeV, Max=38.40 GeV}
\item{Emid7}{Contributing energy band 7, T/F, Emin=38.40 GeV, Emid=54.31 GeV, Max=76.80 GeV}
\item{Emid8}{Contributing energy band 8, T/F, Emin=76.80 GeV, Emid=108.61 GeV, Max=153.60 GeV}
\item{Emid9}{Contributing energy band 9, T/F, Emin=153.60 GeV, Emid=217.22 GeV, Max=307.20 GeV}
\item{Distance1}{Distance1, deg.}
\item{Association1a}{Primary association}
\item{Association1b}{Association1b}
\item{Association1c}{Association1c}
\item{Distance2}{Distance2, deg.}
\item{Association2a}{Association2a}
\item{Association2b}{Association2b}
\item{Association2c}{Association2c}
\item{Distance3}{Distance3, deg.}
\item{Association3a}{Association3a}
\item{Association3b}{Association3b}
\item{Association3c}{Association3c}
\item{Distance4}{Distance4, deg.}
\item{Association4a}{Association4a}
\item{Association4b}{Association4b}
\item{Association4c}{Association4c}
\item{Chi2_PL}{Chi-squared (power-law fit), See Equation (2) of Selig et al. (2015)}
\item{Chi2_LP}{Chi-squared (log-parabola fit), See Equation (3) of Selig et al. (2015)}
\item{Chi2_EXP}{Chi-squared (exponential cut-off fit), See Equation (4) of Selig et al. (2015)}
\item{Gamma_PL}{Spectral index (power-law fit), See Equation (2) of Selig et al. (2015)}
\item{Unc_Gamma_PL}{Uncertainty in the spectral index (power-law fit), See Equation (2) of Selig et al. (2015)}
\item{Gamma_LP}{Spectral index (log-parabola fit), See Equation (3) of Selig et al. (2015)}
\item{Unc_Gamma_LP}{Uncertainty in the spectral index (log-parabola fit), See Equation (3) of Selig et al. (2015)}
\item{Gamma_EXP}{Spectral index (exponential cut-off fit), See Equation (4) of Selig et al. (2015)}
\item{Unc_Gamma_EXP}{Uncertainty in the spectral index (exponential cut-off fit), See Equation (4) of Selig et al. (2015)}
\item{K_PL}{Normalization (power-law fit), See Equation (2) of Selig et al. (2015)}
\item{Unc_K_PL}{Uncertainty in the normalization (power-law fit), See Equation (2) of Selig et al. (2015)}
\item{K_LP}{Normalization (log-parabola fit), See Equation (3) of Selig et al. (2015)}
\item{Unc_K_LP}{Uncertainty in the normalization (log-parabola fit), See Equation (3) of Selig et al. (2015)}
\item{K_EXP}{Normalization (exponential cut-off fit), See Equation (4) of Selig et al. (2015)}
\item{Unc_K_EXP}{Uncertainty in the normalization (exponential cut-off fit), See Equation (4) of Selig et al. (2015)}
\item{Beta_LP}{Beta index (log-parabola fit), See Equation (3) of Selig et al. (2015)}
\item{Unc_Beta_LP}{Uncertainty in the Beta index (log-parabola fit), See Equation (3) of Selig et al. (2015)}
\item{Ec_EXP}{Energy cut-off (exponential cut-off fit), See Equation (4) of Selig et al. (2015)}
\item{Unc_Ec_EXP}{Uncertainty in the energy cut-off (exponential cut-off fit), See Equation (4) of Selig et al. (2015)}
}
}
\keyword{datasets}

