% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-cor.R
\docType{data}
\name{score_cor_pearson}
\alias{score_cor_pearson}
\alias{score_cor_spearman}
\title{Scoring via correlation coefficient}
\format{
An object of class \code{filtro::class_score_cor} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.

An object of class \code{filtro::class_score_cor} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.
}
\usage{
score_cor_pearson

score_cor_spearman
}
\value{
An S7 object. The primary property of interest is in \code{results}. This
is a data frame of results that is populated by the \code{fit()} method and has
columns:
\itemize{
\item \code{name}: The name of the score (e.g., \code{score_cor_pearson} or \code{score_cor_spearman}).
\item \code{score}: The estimates for each predictor.
\item \code{outcome}: The name of the outcome column.
\item \code{predictor}: The names of the predictor inputs.
}

These data are accessed using \code{object@results} (see examples below).
}
\description{
These two objects can be used to compute importance scores based on
correlation coefficient.
}
\details{
These objects are used when:
\itemize{
\item The predictors are numeric and the outcome is numeric.
}

In this case, a correlation coefficient (via \code{\link[stats:cov.wt]{stats::cov.wt()}}) is computed with
the proper variable roles. Values closer to 1 or -1 (i.e., \code{abs(cor_pearson)}
closer to 1) are associated with more important predictors.
\subsection{Estimating the scores}{

In \pkg{filtro}, the \verb{score_*} objects define a scoring method (e.g., data
input requirements, package dependencies, etc). To compute the scores for
a specific data set, the \code{fit()} method is used. The main arguments for
these functions are:

\describe{
\item{\code{object}}{A score class object (e.g., \code{score_cor_pearson}).}
\item{\code{formula}}{A standard R formula with a single outcome on the right-hand side and one or more predictors (or \code{.}) on the left-hand side. The data are processed via \code{\link[stats:model.frame]{stats::model.frame()}}}
\item{\code{data}}{A data frame containing the relevant columns defined by the formula.}
\item{\code{...}}{Further arguments passed to or from other methods.}
\item{\code{case_weights}}{A quantitative vector of case weights that is the same length as the number of rows in \code{data}. The default of \code{NULL} indicates that there are no case weights.}
}
}

Missing values are removed for each predictor/outcome combination being
scored.

In cases where the underlying computations fail, the scoring proceeds
silently, and a missing value is given for the score.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

ames <- modeldata::ames

# Pearson correlation
ames_cor_pearson_res <-
  score_cor_pearson |>
  fit(Sale_Price ~ ., data = ames)
ames_cor_pearson_res@results

# Spearman correlation
ames_cor_spearman_res <-
  score_cor_spearman |>
  fit(Sale_Price ~ ., data = ames)
ames_cor_spearman_res@results
\dontshow{\}) # examplesIf}
}
\seealso{
Other class score metrics: 
\code{\link{score_aov_pval}},
\code{\link{score_imp_rf}},
\code{\link{score_info_gain}},
\code{\link{score_roc_auc}},
\code{\link{score_xtab_pval_chisq}}
}
\concept{class score metrics}
\keyword{datasets}
