% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{show_best_score_num}
\alias{show_best_score_num}
\title{Show best score, based on number of predictors \emph{(singular)}}
\arguments{
\item{x}{A score class object (e.g., \code{score_cor_pearson}).}

\item{...}{Further arguments passed to or from other methods.}

\item{num_terms}{An integer value specifying the number
of predictors to consider.}
}
\value{
A tibble of score results.
}
\description{
Show best score, based on number of predictors \emph{(singular)}
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)

ames_subset <- modeldata::ames |>
  dplyr::select(
    Sale_Price,
    MS_SubClass,
    MS_Zoning,
    Lot_Frontage,
    Lot_Area,
    Street
  )
ames_subset <- ames_subset |>
  dplyr::mutate(Sale_Price = log10(Sale_Price))

ames_aov_pval_res <-
  score_aov_pval |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_aov_pval_res@results

# Show best score
ames_aov_pval_res |> show_best_score_num(num_terms = 2)
\dontshow{\}) # examplesIf}
}
