% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findGSE_v1.95_new.R
\name{filter_peaks_raw}
\alias{filter_peaks_raw}
\title{Filter Peaks from Raw K-mer Histogram}
\usage{
filter_peaks_raw(peaks, histo)
}
\arguments{
\item{peaks}{A data frame containing the peaks from the histogram.}

\item{histo}{A data frame representing the raw k-mer histogram.}
}
\value{
A data frame with filtered peaks.
}
\description{
This function filters peaks from a raw k-mer histogram to find a major peak with enough support information on both sides.
}
\examples{
peaks <- data.frame(V1=1:20, V2=sample(1:10, 20, replace=TRUE))
histo <- data.frame(V1=1:100, V2=sample(1:10, 100, replace=TRUE))
filtered_peaks <- filter_peaks_raw(peaks, histo)
print(filtered_peaks)

}
