% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{mfrr_em_ordered_regulations_up}
\alias{mfrr_em_ordered_regulations_up}
\title{Ordered up-regulations from Balancing energy market in Finland}
\usage{
mfrr_em_ordered_regulations_up(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type MWh/h.
}
\description{
Ordered up-regulations from Balancing energy market in Finland. The volume of ordered up-regulations from Balancing energy market in Finland is published hourly with two hours delay, eg. information from hour 06-07 is published at 9 o'clock.Balancing energy market is market place for manual freqeuncy restoration reserve (mFRR) which is used to balance the electricity generation and consumption in real time. The Balancing energy market organized by Fingrid is part of the Nordic Balancing energy market that is called also Regulating power market. Fingrid orders up- or down-regulation from the Balancing energy market. Up-regulation considers increasing of generation or reducing of consumption.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- mfrr_em_ordered_regulations_up(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/34
}
