% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire_exp_dir_multi.R
\name{fire_exp_dir_multi}
\alias{fire_exp_dir_multi}
\title{Summarize directional load for multiple values}
\usage{
fire_exp_dir_multi(exposure, values, ...)
}
\arguments{
\item{exposure}{SpatRaster from \code{\link[=fire_exp]{fire_exp()}}}

\item{values}{Spatvector of value as a point or simplified polygon}

\item{...}{arguments passed to \code{\link[=fire_exp_dir]{fire_exp_dir()}}.}
}
\value{
a data.frame of the features with attributes: value featureID,
degree, seg1 (binary), seg2 (binary), seg3 (binary), full (binary),
outer (binary).
}
\description{
\code{fire_exp_dir_multi()} summarizes the directional vulnerability
load for multiple points in a study area in a table.
}
\details{
This function summarizes multiple directional vulnerability assessments into
a single table. For each degree, the frequency of input values with
a continuous pathway at that trajectory is found. This summary can be useful
in identifying trends in directional exposure to values within a regional
area of interest.

Continuous pathways are assessed for the full span of all three
directional assessment transect segments, or limited to the outer two
segments. If the values being assessed are variable sizes and being
represented as points, using the outer option is recommended. The inner-most
segment is sensitive to the size of the value when a point is used.
Adjusting the parameters for \code{fire_exp_dir()} is also supported. See details
in \code{\link[=fire_exp_dir]{fire_exp_dir()}} for more information.
}
\examples{
# read example hazard data
hazard_file_path <- "extdata/hazard.tif"
hazard <- terra::rast(system.file(hazard_file_path, package = "fireexposuR"))

# generate 10 random example points within the hazard extent
e <- terra::buffer(terra::vect(terra::ext(hazard), crs = hazard), -15500)
points <- terra::spatSample(e, 10)

# compute exposure metric
exposure <- fire_exp(hazard)

# directional load for multiple points
fire_exp_dir_multi(exposure, points, interval = 10)
}
\references{
Beverly JL, Forbes AM (2023) Assessing directional vulnerability to
wildfire. \emph{Natural Hazards} \strong{117}, 831-849.
\doi{10.1007/s11069-023-05885-3}
}
