% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SecurityHeaders_helpers.R
\name{sts}
\alias{sts}
\title{Construct settings for the \code{Strict-Transport-Security} header}
\usage{
sts(max_age, include_sub_domains = NULL, preload = NULL)
}
\arguments{
\item{max_age}{The maximum age the settings should be kept in the browser
cache, in seconds. Recommended value is 63072000 (2 years)}

\item{include_sub_domains}{Logical. Should subdomains be included in the
policy}

\item{preload}{Allow the settings to be cached and preloaded by a third-party,
e.g. Google or Mozilla. Can only be set if \code{include_sub_domains} is \code{TRUE}
and \code{max_age} is at least 31536000 (1 year)}
}
\value{
A bare list with the input arguments
}
\description{
This helper function exists mainly to document the possible values and
prevent misspelled directives. It returns a bare list. See
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Strict-Transport-Security}{MDN}
for more information on the header
}
\examples{
# Default settings
sts(
  max_age = 63072000,
  include_sub_domains = TRUE
)

}
