% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.fitPS.R
\name{var.psData}
\alias{var.psData}
\title{An S3 method for computing the variance of clothing survey for the number of
groups or size of groups}
\usage{
\method{var}{psData}(x, ...)
}
\arguments{
\item{x}{an object of class \code{psData}---\code{\link{readData}} for more
details.}

\item{...}{other arguments which are passed to \code{\link[base]{sum}}}
}
\value{
the mean of the data. If there are \eqn{r_i}{r[i]} observations of
  the value \eqn{n_i}{n[i]} then the variance is computed by
  \eqn{\mathrm{E}[X^2]-\mathrm{E}[X]^2}{E[X^2]-E[X]^2}, where
  \eqn{\mathrm{E}[X]}{E[X]} is computed using \deqn{\sum_i\frac{r_i\times
  n_i}{\sum_i{r_i}}}{sum(r[i]*n[i])/sum(r[i])} , and
  \eqn{\mathrm{E}[X^2]}{E[X^2]} is computed by \deqn{\sum_i\frac{r_i\times
  n_i^2}{\sum_i{r_i}}}{sum(r[i]*n[i]^2)/sum(r[i])}. We realise that the
  computational formula,
  \eqn{\mathrm{E}[X^2]-\mathrm{E}[X]^2}{E[X^2]-E[X]^2}, is usually not
  regarded as computationally stable, but the magnitude of the numbers
  involved is such that, that this is not likely to cause an issue.
}
\description{
An S3 method for computing the variance of clothing survey for the number of
groups or size of groups
}
\examples{
data(Psurveys)
var(Psurveys$roux)
}
