% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{makeFitPolyFiles}
\alias{makeFitPolyFiles}
\title{Make input files for fitPoly containing only selected rows and columns}
\usage{
makeFitPolyFiles(datpoly, datdiplo=NA, out,
filetype=c("dat", "RData")[2], Rquantile=0.95, marker.threshold,
Rthreshold.param=c(0.95, 0.5, 0))
}
\arguments{
\item{datpoly}{data.frame as produced by readFullDataTable, readAxiomSummary
or splitNrenameSamples, with at least columns MarkerName, SampleName, R and
ratio}

\item{datdiplo}{data.frame as produced by splitNrenameSamples, with at least
columns MarkerName, SampleName, R and ratio, containing the data for the
diploid samples; or NA (default)}

\item{out}{output files will be named out + _poly.RData and _diplo.RData
(or .dat if filetype is set to "dat"). If NA no files are written}

\item{filetype}{"RData" (default) or "dat": the format to save the data in}

\item{Rquantile}{a value between 0 and 1: the R (= X + Y) quantile on which
selection of markers is based}

\item{marker.threshold}{the minimum value of the Rquantile for a marker to be
selected}

\item{Rthreshold.param}{a vector of length 3, defining an R threshold for
selecting samples within each marker.
The first number is the R quantile, the second is a number to multiply that
R quantile with, and the third is the minimum value of the result.
The default of c(0.95, 0.5, 0) means that 0.5 * the 95% quantile of R is used
(which is always higher than 0, the minimum result). This is often a good
cut-off value to discard samples within a marker.}
}
\value{
a list with two elements: datpoly is a filtered version of
parameter datpoly, and if param datdiplo was specified the second element
of the returned list is datdiplo: a filtered version of parameter datdiplo.
Either or both may have 0 rows left after filtering. If no datdiplo was
specified the second element of the list is NA.\cr
If parameter out is specified the element(s) of this list are also saved
as files.
}
\description{
Remove entire markers and ratios for samples within markers
from fitPoly inputfiles if their R levels are below some thresholds;
also keep only the MarkerName, SampleName, X, Y, R and ratio columns
}
\details{
All rows for markers not meeting the marker.threshold for the
R quantile are removed from the original data.frames. For samples within
the remaining markers where the R value is below the marker-specific threshold
the ratio is set to NA, the row for that sample is not removed.
The same thresholds are applied to datpoly and datdiplo.
}
