% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/120b_gpd_k1_libs.R
\name{gpd_k1_means}
\alias{gpd_k1_means}
\title{Analytical Expressions for Predictive Means
RHP mean based on the expectation of DMGS equation 2.1}
\usage{
gpd_k1_means(
  means,
  ml_params,
  lddi,
  lddi_k2,
  lddd,
  lddd_k2,
  lambdad_flat,
  lambdad_rh_mle,
  lambdad_rh_flat,
  lambdad_jp,
  nx,
  dim = 2,
  kloc = 0
)
}
\arguments{
\item{means}{logical that indicates whether to return analytical estimates for the distribution means (longer runtime)}

\item{ml_params}{parameters}

\item{lddi}{inverse observed information matrix}

\item{lddi_k2}{inverse observed information matrix, fixed shape parameter}

\item{lddd}{third derivative of log-likelihood}

\item{lddd_k2}{third derivative of log-likelihood, fixed shape parameter}

\item{lambdad_flat}{derivative of the log flat prior}

\item{lambdad_rh_mle}{derivative of the log CRHP-MLE prior}

\item{lambdad_rh_flat}{derivative of the log CRHP-FLAT prior}

\item{lambdad_jp}{derivative of the log JP prior}

\item{nx}{length of training data}

\item{dim}{number of parameters}

\item{kloc}{the known location parameter}
}
\value{
Two scalars
}
\description{
Analytical Expressions for Predictive Means
RHP mean based on the expectation of DMGS equation 2.1
}
