% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectors.R
\name{set_vector}
\alias{set_vector}
\title{Generate a vector of a values from a set}
\usage{
set_vector(size, set = NULL, set_type = NULL, set_size = NULL, ...)
}
\arguments{
\item{size}{integer, vector length}

\item{set}{vector a set of values to pick from; default: NULL}

\item{set_type}{string if set is NULL generate a random set of type
("integer", "string", "boolean", "numeric"); default: NULL}

\item{set_size}{integer, number of elements in random set; default: NULL}

\item{...}{additional arguments for random set generator.
For details check \code{\link{random_vector}}}
}
\description{
Generate a vector of a values from a set
}
\note{
When using a random set, be aware, that set has to be unique,
 thus if arguments passed to generator do not allow this, the function
 can end up in an infinite loop.
}
\examples{
set_vector(10, set = c("a", "b", "c"))
set_vector(size = 5, set_type = "string", set_size = 3)
}
