% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{check_simulator}
\alias{check_simulator}
\title{Check if simulator with fixed quantiles is well implemented}
\usage{
check_simulator(
  simulatorQ,
  ndraw,
  Theta_lower = 0,
  Theta_upper = 1,
  ntheta = 5,
  nruns = 3
)
}
\arguments{
\item{simulatorQ}{Function of type simulatorQ(Theta, quantiles)
where Theta is the parameter set for the simulations and
quantiles are drawn in U(0,1).}

\item{ndraw}{Integer. Number of random variables to draw
for one simulation of the model.}

\item{Theta_lower}{1D numeric array. Lower bounds of Theta parameters.}

\item{Theta_upper}{1D numeric array. Upper bounds of Theta parameters.}

\item{ntheta}{Integer. Number of Theta parameters to test.}

\item{nruns}{Integer. For each Theta, number of simulations to run.}
}
\value{
Boolean. True if no random effect was detected, False else.
}
\description{
Run simulations to catch random variations.
Warning : does not check it formally.
Warning : does not check if quantiles are used several times.
}
\examples{
simulatorQ <- function(Theta, quantiles){
qpois(quantiles, lambda = Theta)
}
check_simulator(simulatorQ, 5,
Theta_lower = 50, Theta_upper = 150)

}
