% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_flocker.R
\name{predict_flocker}
\alias{predict_flocker}
\title{Get posterior predictions from a flocker model}
\usage{
predict_flocker(
  flocker_fit,
  draw_ids = NULL,
  history_condition = FALSE,
  new_data = NULL,
  mixed = FALSE,
  allow_new_levels = FALSE,
  sample_new_levels = "uncertainty"
)
}
\arguments{
\item{flocker_fit}{A `flocker_fit` object}

\item{draw_ids}{Vector of indices of the posterior draws to be 
used. If `NULL` (the default) all draws are used in their native order.}

\item{history_condition}{Logical indicator of whether to directly condition the 
posterior for the occupancy state on the observed detection histories.
For example, at sites with at least one detection, the true occupancy 
state conditioned on the history is one with absolute certainty. Without 
directly conditioning on the history, the occupancy state is controlled 
exclusively by the posterior distribution for the occupancy probability 
psi.}

\item{new_data}{Optional new data at which to predict. If `NULL`, predictions
are given at the data points used for model fitting. Otherwise, must
be a flocker_data object produced by `make_flocker_data`.}

\item{mixed}{When `new_data` is not provided, should random effect levels be
drawn from their posteriors (`FALSE`, the default) or re-sampled from 
their fitted hyperparameters (`TRUE`). The latter can be useful for mixed
predictive checking. Note that setting to TRUE is not available for
grouping terms involved in phylogenetic random effects or other random 
effects with specified covariance structures.}

\item{allow_new_levels}{Should new_data be allowed to contain new levels for
random effects?}

\item{sample_new_levels}{If new_data is provided and contains random effect
levels not present in the original data, how should predictions be
handled? Passed directly to brms::prepare_predictions, which see.}
}
\value{
An array of posterior predictions in the same shape as the
    observations passed to `make_flocker_data()` with posterior iterations
    stacked along the final dimension.
}
\description{
Get posterior predictions from a flocker model
}
\examples{
\donttest{
unconditioned_preds <- predict_flocker(example_flocker_model_single)
conditioned_preds <- predict_flocker(
 example_flocker_model_single, 
 history_condition = TRUE
)
}
}
