% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_FLPS.r
\name{runFLPS}
\alias{runFLPS}
\title{Conduct fully latent principal stratification}
\usage{
runFLPS(
  inp_data = NULL,
  compiled_stan = NULL,
  outcome = NULL,
  trt = NULL,
  covariate = NULL,
  lv_model = NULL,
  lv_type = NULL,
  priors_input = NULL,
  stan_options = list(),
  ...
)
}
\arguments{
\item{inp_data}{A matrix or data frame containing the input data.}

\item{compiled_stan}{An object of S4 class stanmodel produced by the
\code{modelBuilder} function.}

\item{outcome}{A character string specifying the outcome variable's name.}

\item{trt}{A character string specifying the treatment or control group variable's name.}

\item{covariate}{A character string specifying the covariate variable names.}

\item{lv_model}{A description of the latent variable model using syntax
akin to the \pkg{lavaan} package. Key operators include:
 \itemize{
   \item \code{=~} : Denotes associations between factors and indicators (e.g., F1 =~ v1 + v2 + v3). All indicators associated with the corresponding factor should be
   written in the same line with \code{+}.
   \item \code{+} : Specifies a series of indicators.
 }}

\item{lv_type}{A character string indicating the type of latent variable models.}

\item{priors_input}{A list specifying the priors or defaults to N(0, 5) if not provided.
Relevant parameters: \code{tau0} (group difference), \code{tau1} (principal effects),
and \code{omega} (effect of latent factors on outcome).
Ensure that the lengths of \code{tau1} and \code{omega} match the number of factors.
Examples:
 \itemize{
   \item \code{list(tau0 = c(0, 1), tau1 = c(0.5, 1))} : Mean and variance for normal priors.
   \item \code{list(tau1 = list(c(0.5, 1), c(-0.4, 1)))} : For two factors.
 }}

\item{stan_options}{A list of options for [rstan::stan()], specified as 'name = value'.}

\item{...}{Additional parameters for the latent variable models
 \itemize{
 \item  \code{nclass} A number specifying the number of latent classes.
 \item  \code{multilevel} A logical indicating if a multilevel structure is present.
 \item  \code{lv_randomeffect} A logical indicating whether to estimate random effects for latent variables.
 \item \code{group_id} A string for grouping variable for multilevel structure.
}}
}
\value{
An object of class \code{flps} encompassing a \code{\link[rstan]{stanfit}} object.
Components include:
 \item{call}{Function call with arguments.}
 \item{inp_data}{The input data frame provided.}
 \item{flps_model}{The Stan syntax used in [rstan::stan()].}
 \item{flps_data}{Data list used for [rstan::stan()].}
 \item{flps_fit}{Resulting \code{\link[rstan]{stanfit}} object.}
 \item{time}{A numeric; Time taken for computation}
}
\description{
Conduct fully latent principal stratification
}
\examples{
\donttest{
inp_data <- flps::makeInpData(
  N       = 200,
  R2Y     = 0.2,
  R2eta   = 0.5,
  omega   = 0.2,
  tau0    = 0.23,
  tau1    = -0.16,
  betaL   = 0.1,
  betaY   = 0.2,
  lambda  = 0.8,
  nitem    = 10,
  nfac    = 1,
  lvmodel = 'rasch' )

res <- runFLPS(
   inp_data = inp_data,
   outcome = "Y",
   trt = "Z",
   covariate = c("X1"),
   lv_type = "rasch",
   lv_model = "F =~ v1 + v2 + v3 + v4 + v5 + v6 + v7 + v8 + v9 + v10",
   stan_options = list(iter = 1000, warmup = 500, cores = 1, chains = 2)
   )
}

}
\seealso{
[rstan::stan()]
}
\concept{rstan}
