% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg-constructor.R
\name{regressor}
\alias{regressor}
\title{Construct a Regressor Object}
\usage{
regressor(
  onsets,
  hrf = HRF_SPMG1,
  duration = 0,
  amplitude = 1,
  span = 40,
  summate = TRUE
)
}
\arguments{
\item{onsets}{A numeric vector of event onset times in seconds.}

\item{hrf}{The hemodynamic response function (HRF) to convolve with the events.
This can be a pre-defined `HRF` object (e.g., `HRF_SPMG1`), a custom `HRF` 
object created with `as_hrf`, a function `f(t)`, or a character string 
referring to a known HRF type (e.g., "spmg1", "gaussian"). Defaults to `HRF_SPMG1`.}

\item{duration}{A numeric scalar or vector specifying the duration of each event 
in seconds. If scalar, it's applied to all events. Defaults to 0 (impulse events).}

\item{amplitude}{A numeric scalar or vector specifying the amplitude (scaling factor) 
for each event. If scalar, it's applied to all events. Defaults to 1.}

\item{span}{The temporal window (in seconds) over which the HRF is defined 
or evaluated. This influences the length of the convolution. If not provided, 
it may be inferred from the `hrf` object or default to 40s. **Note:** Unlike some
previous versions, the `span` is not automatically adjusted based on `duration`;
ensure the provided or inferred `span` is sufficient for your longest event duration.}

\item{summate}{Logical scalar; if `TRUE` (default), the HRF response amplitude scales
with the duration of sustained events (via internal convolution/summation). If `FALSE`,
the response reflects the peak HRF reached during the event duration.}
}
\value{
An S3 object of class `Reg` and `list`
  containing processed event information and the HRF specification. The
  object includes a `filtered_all` attribute indicating whether all events
  were removed due to zero or `NA` amplitudes.
}
\description{
Creates an object representing event-related regressors for fMRI modeling.
This function defines event onsets and associates them with a hemodynamic 
response function (HRF) to generate predicted time courses.
}
\details{
This function serves as the main public interface for creating regressor objects. 
Internally, it utilizes the `Reg()` constructor which performs validation and 
efficient storage. The resulting object can be evaluated at specific time points 
using the `evaluate()` function.

Events with an amplitude of 0 are automatically filtered out.
}
\examples{
# Create a simple regressor with 3 events
reg <- regressor(onsets = c(10, 30, 50), hrf = HRF_SPMG1)

# Regressor with durations and amplitudes
reg2 <- regressor(
  onsets = c(10, 30, 50),
  duration = c(2, 2, 2),
  amplitude = c(1, 1.5, 0.8),
  hrf = HRF_SPMG1
)

# Using different HRF types
reg_gamma <- regressor(onsets = c(10, 30), hrf = "gamma")

# Evaluate regressor at specific time points
times <- seq(0, 60, by = 0.1)
response <- evaluate(reg, times)
}
