% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idio.R
\name{threshold}
\alias{threshold}
\title{Threshold the entries of the input matrix at a data-driven level}
\usage{
threshold(mat, path.length = 500)
}
\arguments{
\item{mat}{input parameter matrix}

\item{path.length}{number of candidate thresholds}
}
\value{
an S3 object of class \code{threshold}, which contains the following fields:
\item{threshold}{ data-driven threshold}
\item{thr.mat}{ thresholded input matrix}
}
\description{
Threshold the entries of the input matrix at a data-driven level.
This can be used to perform edge selection for VAR parameter, inverse innovation covariance, and long-run partial correlation networks.
}
\details{
See Owens, Cho & Barigozzi (2024+) for more information on the threshold selection process
}
\examples{
\dontrun{
library(fnets)
out <- fnets(data.unrestricted,
   var.args = list(n.cores = 2)
)
# Granger-causal network
th1 <- threshold(out$idio.var$beta)
plot(th1)
print(th1)
# Partial correlations
th2 <- threshold(out$lrpc$pc)
# Long-run partial correlations
th3 <- threshold(out$lrpc$lrpc)
}
}
\references{
Owens, D., Cho, H. & Barigozzi, M. (2024+) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling. The R Journal (to appear).
}
\seealso{
\link[fnets]{plot.threshold}, \link[fnets]{print.threshold}
}
