% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GR4J_funcs.R
\name{calGR4J}
\alias{calGR4J}
\title{Calibrate GR4J rainfall runoff model parameters}
\usage{
calGR4J(dates, P, PET, Qobs, plotResults = F)
}
\arguments{
\item{dates}{is a vector of daily dates}

\item{P}{is a vector of daily precipitation data (in mm)}

\item{PET}{is a vector of daily potential evapotranspiration data (in mm)}

\item{Qobs}{is the observed daily streamflow (in mm)}

\item{plotResults}{is a logical indicating whether airGR summary plots are to be produced}
}
\value{
A vector with GR4J parameter values
}
\description{
\code{calGR4J} calibrates the GR4J model using the airGR package. The NSE is used as the objective function.
}
\examples{
# load dates, precip, PET and streamflow data for Scott Creek
data('data_A5030502')
clim_ref = list(times = data_A5030502$times,P = data_A5030502$P)  
data("egScottCreekSimStoch")
# observed flow
Qobs = data_A5030502$Qobs
# observed PET 
PET = data_A5030502$PET 
dates = as.Date(clim_ref$times)
# calibrate GR4J parameters
Param = calGR4J(dates = dates,P=clim_ref$P,PET=PET,Qobs=Qobs)
#' @import airGR
}
