% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{forest_theme}
\alias{forest_theme}
\title{Forest plot default theme}
\usage{
forest_theme(
  base_size = 12,
  base_family = "",
  ci_pch = 15,
  ci_col = "black",
  ci_alpha = 1,
  ci_fill = NULL,
  ci_lty = 1,
  ci_lwd = 1,
  ci_Theight = NULL,
  legend_name = "Group",
  legend_position = "right",
  legend_value = "",
  legend_gp = gpar(fontsize = base_size, fontfamily = base_family, cex = 1),
  legend_ncol = 1,
  legend_byrow = TRUE,
  xaxis_gp = gpar(fontsize = base_size, fontfamily = base_family, lwd = 0.6, cex = 1),
  refline_gp = gpar(lwd = 1, lty = "dashed", col = "grey20"),
  vertline_lwd = 1,
  vertline_lty = "dashed",
  vertline_col = "grey20",
  summary_col = "#4575b4",
  summary_fill = summary_col,
  footnote_gp = gpar(fontsize = base_size, fontfamily = base_family, cex = 0.6, fontface
    = "plain", col = "black"),
  footnote_parse = TRUE,
  title_just = c("left", "right", "center"),
  title_gp = gpar(cex = 1.2, fontface = "bold", col = "black", fontfamily = base_family),
  arrow_type = c("open", "closed"),
  arrow_label_just = c("start", "end"),
  arrow_length = 0.05,
  arrow_gp = gpar(fontsize = base_size, fontfamily = base_family, lwd = 0.6),
  xlab_adjust = c("refline", "center"),
  xlab_gp = gpar(fontsize = base_size, fontfamily = base_family, cex = 1, fontface =
    "plain"),
  ...
)
}
\arguments{
\item{base_size}{The size of text}

\item{base_family}{The font family}

\item{ci_pch}{Shape of the point estimation. It will be reused if the
forest plot is grouped.}

\item{ci_col}{Color of the CI. A vector of color should be provided for
the grouped forest plot. An internal color set will be if only not.}

\item{ci_alpha}{Scalar value, alpha channel for transparency of point estimation.
A small vertical line will be added to indicate the point estimation if this
is not equals to 1.}

\item{ci_fill}{Color fill the point estimation. A vector of color should be
provided for the grouped forest plot. If this is \code{NULL} (default), the
value will inherit from \code{"ci_col"}. This is valid only if
\code{ci_pch} within 15:25.}

\item{ci_lty}{Line type of the CI. A vector of line type should be provided
for the grouped forest plot.}

\item{ci_lwd}{Line width of the CI. A vector of line type should be provided
for the grouped forest plot.}

\item{ci_Theight}{A unit specifying the height of the T end of CI. If set to
\code{NULL} (default), no T end will be drawn.}

\item{legend_name}{Title of the legend.}

\item{legend_position}{Position of the legend, \code{"right"}, \code{"top"},
\code{"bottom"} or \code{"none"} to suppress the legend.}

\item{legend_value}{Legend labels (expressions). A vector should be provided
for the grouped forest plot. A "Group 1" etc will be created if not a vector
for a grouped forest plot.}

\item{legend_gp}{\code{gpar} graphical parameters of legend, see \code{\link[grid]{gpar}}.}

\item{legend_ncol}{integer; the number of columns, see \code{\link[grid]{legendGrob}}.}

\item{legend_byrow}{logical indicating whether rows of the legend are filled first, see \code{\link[grid]{legendGrob}}.}

\item{xaxis_gp}{\code{gpar} graphical parameters of x-axis, see \code{\link[grid]{gpar}}.}

\item{refline_gp}{\code{gpar} graphical parameters of reference line, see \code{\link[grid]{gpar}}.}

\item{vertline_lwd}{Line width for extra vertical line. A vector can be provided
for each vertical line, and the values will be recycled if no enough values are
given.}

\item{vertline_lty}{Line type for extra vertical line. Works same as \code{vertline_lwd}.}

\item{vertline_col}{Line color for the extra vertical line. Works same as \code{vertline_lwd}.}

\item{summary_col}{Color for borders of the summary diamond shape.}

\item{summary_fill}{Color for filling the summary diamond shape.}

\item{footnote_gp}{\code{gpar} graphical parameters of footnote, see \code{\link[grid]{gpar}}.}

\item{footnote_parse}{Parse footnote text (default).}

\item{title_just}{The justification of the title, default is \code{'left'}.}

\item{title_gp}{\code{gpar} graphical parameters of title, see \code{\link[grid]{gpar}}.}

\item{arrow_type}{Type of the arrow below x-axis, see \code{\link[grid]{arrow}}.}

\item{arrow_label_just}{The justification of the arrow label relative to arrow. Control
the arrow label to align to the starting point of the arrow \code{"start"} (default) or
the ending point of the arrow \code{"end"}.}

\item{arrow_length}{The length of the arrow head, default is \code{0.05}.
See \code{\link[grid]{arrow}}.}

\item{arrow_gp}{\code{gpar} graphical parameters of arrow, see \code{\link[grid]{gpar}}.}

\item{xlab_adjust}{Control the alignment of xlab to reference line (default) or center of the x-axis.}

\item{xlab_gp}{\code{gpar} graphical parameters of xlab, see \code{\link[grid]{gpar}}.}

\item{...}{Other parameters passed to table. See \code{\link[gridExtra]{tableGrob}}
for details.}
}
\value{
A list.
}
\description{
Default theme for the forest plot, but can pass other parameters. The
parameters will be passed to corresponding elements of the forest plot.

\itemize{
\item \code{ci_*} Control the graphical parameters of confidence intervals
\item \code{legend_*} Control the graphical parameters of legend
\item \code{xaxis_*} Control the graphical parameters of x-axis
\item \code{refline_*} Control the graphical parameters of reference line
\item \code{vertline_*} Control the graphical parameters of vertical line
\item \code{summary_*} Control the graphical parameters of diamond shaped summary CI
\item \code{footnote_*} Control the graphical parameters of footnote
\item \code{title_*} Control the graphical parameters of title
\item \code{arrow_*} Control the graphical parameters of arrow
}

See \code{\link[grid]{gpar}} for more details.
}
\seealso{
\code{\link[gridExtra]{tableGrob}} \code{\link{forest}} \code{\link[grid]{textGrob}}
\code{\link[grid]{gpar}} \code{\link[grid]{arrow}} \code{\link[grid]{segmentsGrob}}
\code{\link[grid]{linesGrob}} \code{\link[grid]{pointsGrob}} \code{\link[grid]{legendGrob}}
}
