% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{children_sort}
\alias{children_sort}
\title{Sort chidren nodes with certain order}
\usage{
children_sort(input_node, input_order, mismatch_last = T)
}
\arguments{
\item{input_node}{input node}

\item{input_order}{children node order}

\item{mismatch_last}{TRUE: mismatched children nodes are at the bottom; FALSE: mismatched nodes are at the top}
}
\value{
tree with children nodes sorted with certian order
}
\description{
Sort chidren nodes with certain order
}
\examples{
data(test_df)
test_node <- data.tree::as.Node(test_df)
sorted_node <- children_sort(
  input_node = test_node,
  input_order = c("groupB", "groupA"),
  mismatch_last = TRUE)
print(sorted_node)
}
