% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_power.R
\name{format_power-deprecated}
\alias{format_power-deprecated}
\title{Format powers of ten}
\usage{
format_power(x, digits, ..., format, size, omit_power, set_power, delim)
}
\arguments{
\item{x}{Numeric vector to be formatted.}

\item{digits}{Numeric scalar between 1 and 20 (inclusive) defining the
number of significant digits in result.}

\item{...}{Not used, force later arguments to be used by name.}

\item{format}{Character. Possible values are "engr" (default) for engineering
notation and and "sci" for scientific notation. Use argument  by name. Can
also be set as a global option, for example,
\code{options(formatdown.power.format = "sci")} that can be overwritten
in an individual function call.}

\item{size}{Font size. Possible values are "scriptsize", "small" (default),
"normalsize", "large", and "huge". which correspond to selected
LaTeX font size values. Can also be set as a global option, for example,
\code{options(formatdown.font.size = "normalsize")} that can be overwritten
in an individual function call.}

\item{omit_power}{Numeric vector \code{c(p, q)} specifying the range of exponents
between which power of ten notation is omitted, where \code{p <= q}. If NULL all
numbers are formatted in powers of ten notation. Use argument by name.}

\item{set_power}{Numeric scalar integer. Assigned exponent that overrides
\code{format}. Default NULL makes no notation changes. Use argument by name.}

\item{delim}{Character vector (length 1 or 2) defining the delimiters for
marking up inline math. Possible values include \code{"$"} or \code{"\\\\("}, both of
which create appropriate left and right delimiters. Alternatively, left and
right can be defined explicitly in a character vector of length two, e.g.,
\code{c("$", "$")} or \code{c("\\\\(", "\\\\)")}. Custom delimiters can be assigned to
suit the markup environment. Use argument by name.}
}
\value{
A character vector with numbers represented in powers of ten
notation and delimited as inline math markup.
}
\description{
This function is deprecated because it's a special case of the new
\code{\link[=format_numbers]{format_numbers()}} function. In addition, the new function includes features
not available in the deprecated function.
}
\details{
Convert the elements of a numerical vector to character strings in which the
numbers are formatted using powers-of-ten notation in scientific or
engineering form and delimited for rendering as inline equations in an R
Markdown document.

Given a number, a numerical vector, or a numerical column from a data frame,
\code{format_power()} converts the numbers to character strings of the form, \code{"$a \\\\times 10^{n}$"}, where \code{a} is the coefficient and \code{n} is the exponent. The
string includes markup delimiters \verb{$...$} for rendering as an inline equation
in R Markdown or Quarto Markdown document.

The user can specify either scientific or engineering format and
the number of significant digits.

Powers-of-ten notation is omitted over a range of exponents via \code{omit_power}
such that numbers are converted to character strings of the form, \code{"$a$"},
where \code{a} is the number in decimal notation. The default \code{omit_power = c(-1, 2)} formats numbers such as 0.123, 1.23, 12.3, and 123 in decimal form. To
cancel these exceptions and convert all numbers to powers-of-ten notation,
set the \code{omit_power} argument to NULL.

Delimiters for inline math markup can be edited if necessary. If the default
argument fails, try using \code{"\\\\("} as an alternative. If using a custom
delimiter to suit the markup environment, be sure to escape all special
symbols.
}
\seealso{
\code{\link{formatdown-deprecated}}
}
\keyword{internal}
