% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.emfrail.R
\name{autoplot.emfrail}
\alias{autoplot.emfrail}
\title{Plots for emfrail objects using \code{ggplot2}}
\usage{
\method{autoplot}{emfrail}(object, type = c("hist", "hr", "pred",
  "frail"), newdata = NULL, lp = NULL, strata = NULL,
  quantity = "cumhaz", type_pred = c("conditional", "marginal"),
  conf_int = "adjusted", conf_level = 0.95, individual = FALSE, ...)
}
\arguments{
\item{object}{\code{emfrail} object, typically result of \code{emfrail()}}

\item{type}{One (or more) of \code{hist} for a histogram of the estimated frailty values,
\code{hr} for a plot of the conditional and marginal hazard ratio between two cases,
\code{pred} for the predicted conditional and marginal cumulative hazard or survival for one case,
\code{frail} for a caterpillar plot of the ordered frailty estimates with confidence intervals, where available.}

\item{newdata}{A \code{data.frame} with values of the covariates. For \code{type == "hr"} the hazard ratio
between the first two rows of \code{newdata} is calculated. For \code{type == "pred"} the prediction
for the first row of \code{newdata} is calculated.}

\item{lp}{A numeric vector of values of the linear predictor, each corresponding to a case. For \code{type == "hr"} the hazard ratio
between the first two values of \code{lp} is calculated. For \code{type == "pred"} the prediction
for the first value of \code{lp} is calculated.}

\item{strata}{The name of the strata (if applicable) for which the prediction should be made.}

\item{quantity}{One of \code{c("cumhaz", "survival")} for \code{type == "pred"}; see \code{quantity} in \code{\link{predict.emfrail}}}

\item{type_pred}{One of \code{c("conditional", "marginal")} for \code{type == "pred"}; see \code{type} in \code{\link{predict.emfrail}}}

\item{conf_int}{One of \code{c("regular", "adjusted")} for \code{type == "pred"}; see \code{conf_int} in \code{\link{predict.emfrail}}}

\item{conf_level}{The width of the confidence interval for \code{type == "pred"}; see \code{conf_level} in \code{\link{predict.emfrail}}}

\item{individual}{Logical, for \code{type == "pred"} to be used for drawing a curve when the rows of \code{newdata} refer to the same individual; see
\code{individual} in \code{\link{predict.emfrail}}}

\item{...}{Further arguments to be passed on to `ggplot` (ignored)}
}
\value{
A list of \code{ggplot2} objects corresponding to the required plots, or one \code{ggplot2} if only one plot is selected

For the catterpillar plot, in the case of the gamma frailty model, the vertical lines represent the 0.025 and 0.975 quantiles of the
posterior gamma distribution. For other distributions, this quantity is not easy to calculate (at least not in closed form)
and only the frailty estimates are shown.
}
\description{
Plots for emfrail objects using \code{ggplot2}
}
\note{
It's normal for \code{autoplot} to give a warning of the type \code{Warning: Ignoring unknown aesthetics: id
}. This is because, in \code{ggplot2} terms, the \code{id} aesthetic is not recognized. This is correct, and for any
practical purpose this will not make a difference (you can safely ignore the warnings). However, this makes it
easier to create an interactive plot out of the resulting object.
}
\examples{
mod_rec <- emfrail(Surv(start, stop, status) ~ treatment + number + cluster(id), bladder1,
control = emfrail_control(ca_test = FALSE, lik_ci = FALSE))

# Histogram of the estimated frailties
autoplot(mod_rec, type = "hist")

# Ordered estimated frailties (with confidence intervals, for gamma distribution)
autoplot(mod_rec, type = "frail")

# hazard ratio between placebo and pyridoxine
newdata1 <- data.frame(treatment = c("placebo", "pyridoxine"),
                       number = c(1, 3))

autoplot(mod_rec, type = "hr", newdata = newdata1)

# predicted cumulative hazard for placebo, and number = 1
autoplot(mod_rec, type = "pred", newdata = newdata1[1,])

# predicted survival for placebo, and number = 1
autoplot(mod_rec, type = "pred", quantity = "survival", newdata = newdata1[1,])

# predicted survival for an individual that switches from
# placebo to pyridoxine at time = 15
\dontrun{
newdata2 <- data.frame(treatment = c("placebo", "pyridoxine"),
                       number = c(1, 3),
                       tstart = c(0, 15),
                       tstop = c(15, Inf))

autoplot(mod_rec, type = "pred", quantity = "survival", newdata = newdata2, individual = TRUE)
}
}
\seealso{
\code{\link{predict.emfrail}}, \code{\link{summary.emfrail}}, \code{\link{plot.emfrail}}.
}
