% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emfrail_aux.R
\name{emfrail_pll}
\alias{emfrail_pll}
\title{Profile log-likelihood calculation}
\usage{
emfrail_pll(formula, data, distribution = emfrail_dist(), values)
}
\arguments{
\item{formula}{Same as in \code{emfrail}}

\item{data}{Same as in \code{emfrail}}

\item{distribution}{Same as in \code{emfrail}}

\item{values}{A vector of values on where to calculate the profile likelihood. See details.}
}
\value{
The profile log-likelihood at the specific value of the frailty parameter
}
\description{
Profile log-likelihood calculation
}
\details{
This function can be used to calculate the profile log-likelihood for different values of \eqn{\theta}.
The scale is that of \code{theta} as defined in \code{emfrail_dist()}.
For the gamma and pvf frailty, that is the inverse of the frailty variance.
}
\note{
This function is just a simple wrapper for \code{emfrail()} with the \code{control} argument
a call from \code{emfrail_control} with the option \code{opt_fit = FALSE}. More flexibility can be obtained
by calling \code{emfrail} with this option, especially
for setting other \code{emfrail_control} parameters.
}
\examples{

fr_var <- seq(from = 0.01, to = 1.4, length.out = 20)
pll_gamma <- emfrail_pll(formula = Surv(time, status) ~  rx + sex + cluster(litter),
 data =  rats,
 values = 1/fr_var )
 plot(fr_var, pll_gamma,
     type = "l",
     xlab = "Frailty variance",
     ylab = "Profile log-likelihood")

# check with coxph;
# attention: theta is the the inverse frailty variance in emfrail,
# but theta is the frailty variance in coxph.

pll_cph <- sapply(fr_var, function(th)
  coxph(data =  rats, formula = Surv(time, status) ~ rx + sex + frailty(litter, theta = th),
        method = "breslow")$history[[1]][[3]])

lines(fr_var, pll_cph, col = 2)

# Same for inverse gaussian
pll_if <- emfrail_pll(Surv(time, status) ~  rx + sex + cluster(litter),
                      rats,
                      distribution = emfrail_dist(dist = "pvf"),
                      values = 1/fr_var )

# Same for pvf with a positive pvfm parameter
pll_pvf <- emfrail_pll(Surv(time, status) ~  rx + sex + cluster(litter),
                       rats,
                       distribution = emfrail_dist(dist = "pvf", pvfm = 1.5),
                       values = 1/fr_var )

miny <- min(c(pll_gamma, pll_cph, pll_if, pll_pvf))
maxy <- max(c(pll_gamma, pll_cph, pll_if, pll_pvf))

plot(fr_var, pll_gamma,
     type = "l",
     xlab = "Frailty variance",
     ylab = "Profile log-likelihood",
     ylim = c(miny, maxy))
points(fr_var, pll_cph, col = 2)
lines(fr_var, pll_if, col = 3)
lines(fr_var, pll_pvf, col = 4)

legend(legend = c("gamma (emfrail)", "gamma (coxph)", "inverse gaussian", "pvf, m=1.5"),
       col = 1:4,
       lty = 1,
       x = 0,
       y = (maxy + miny)/2)
}
