% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovFMean.R
\name{CovFMean}
\alias{CovFMean}
\title{Fréchet mean of covariance matrices}
\usage{
CovFMean(M = NULL, optns = list())
}
\arguments{
\item{M}{A q by q by n array (resp. a list of q by q matrices) where \code{M[,,i]} (resp. \code{M[[i]]}) contains the i-th covariance matrix of dimension q by q.}

\item{optns}{A list of options control parameters specified by \code{list(name=value)}. See `Details'.}
}
\value{
A list containing the following fields:
\item{Mout}{A list containing the Fréchet mean of the covariance matrices in \code{M}.}
\item{optns}{A list containing the \code{optns} parameters utilized.}
}
\description{
Fréchet mean computation for covariance matrices.
}
\details{
Available control options are
\describe{
\item{metric}{Metric type choice, \code{"frobenius"}, \code{"power"}, \code{"log_cholesky"}, \code{"cholesky"} - default: \code{"frobenius"} which corresponds to the power metric with \code{alpha} equal to 1.}
\item{alpha}{The power parameter for the power metric, which can be any non-negative number. Default is 1 which corresponds to Frobenius metric.}
\item{weights}{A vector of weights to compute the weighted barycenter. The length of \code{weights} is equal to the sample size n. Default is equal weights.}
}
}
\examples{
#Example M input
n=10 #sample size
m=5 # dimension of covariance matrices
M <- array(0,c(m,m,n))
for (i in 1:n){
 y0=rnorm(m)
 aux<-diag(m)+y0\%*\%t(y0)
 M[,,i]<-aux
}
Fmean=CovFMean(M=M,optns=list(metric="frobenius"))

}
\references{
\itemize{
\item \cite{Petersen, A. and Müller, H.-G. (2019). Fréchet regression for random objects with Euclidean predictors. The Annals of Statistics, 47(2), 691--719.}
\item \cite{Petersen, A., Deoni, S. and Müller, H.-G. (2019). Fréchet estimation of time-varying covariance matrices from sparse data, with application to the regional co-evolution of myelination in the developing brain. The Annals of Applied Statistics, 13(1), 393--419.}
\item \cite{Lin, Z. (2019). Riemannian geometry of symmetric positive definite matrices via Cholesky decomposition. Siam. J. Matrix. Anal, A. 40, 1353--1370.}
}
}
