% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist4den.R
\name{dist4den}
\alias{dist4den}
\title{\eqn{L^2} Wasserstein distance between two distributions.}
\usage{
dist4den(d1 = NULL, d2 = NULL, fctn_type = NULL, optns = list())
}
\arguments{
\item{d1, d2}{Lists holding the density functions or quantile functions of the two distributions.
Each list consists of two numeric vectors \code{x} and \code{y} of the same length,
where \code{x} holds the support grid and \code{y} holds the values of the function.
Note that the type of functions representing the distributions in \code{d1} and \code{d2}
should be the same---either both are density functions, or both are quantile functions. 
If both are quantile functions, all elements in \code{d1$x} and \code{d2$x} must be between 0 and 1.
\code{d1$x} and \code{d2$x} may have different lengths.}

\item{fctn_type}{Character vector of length 1 holding the function type in \code{d1} and \code{d2} 
representing the distributions: \code{"density"} (default), \code{"quantile"}.}

\item{optns}{A list of control parameters specified by \code{list(name=value)}.}
}
\value{
A scalar holding the \eqn{L^2} Wasserstein distance between \code{d1} and \code{d2}.
}
\description{
\eqn{L^2} Wasserstein distance between two distributions.
}
\details{
Available control options are:
\describe{
\item{nqSup}{A scalar giving the length of the support grid of quantile functions based on which the \eqn{L^2} Wasserstein distance (i.e., the \eqn{L^2} distance between the quantile functions) is computed. Default is 201.}
}
}
\examples{
d1 <- list(x = seq(-6,6,0.01))
d1$y <- dnorm(d1$x)
d2 <- list(x = d1$x + 1)
d2$y <- dnorm(d2$x, mean = 1)
dist <- dist4den(d1 = d1,d2 = d2)
}
