% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot-pkgs.R
\name{check_pkgs_availability}
\alias{check_pkgs_availability}
\title{Check Packages Availability}
\usage{
check_pkgs_availability(pkgs, quietly = TRUE)
}
\arguments{
\item{pkgs}{Character vector of package names. (Typically the output from
\code{spot_pkgs()}).}

\item{quietly}{logical: should progress and error messages be suppressed?}
}
\value{
Named logical vector indicating whether each package is available on
the machine.
}
\description{
Check whether packages are available in current library.
}
\examples{
library(funspotr)
library(dplyr)

file_lines <- "
library(dplyr)
require(tidyr)
library(madeUpPkg)

as_tibble(mpg) \%>\%
  group_by(class) \%>\%
  nest() \%>\%
  mutate(stats = purrr::map(data,
                            ~lm(cty ~ hwy, data = .x)))

made_up_fun()
"

file_output <- tempfile(fileext = ".R")
writeLines(file_lines, file_output)

spot_pkgs(file_output) \%>\%
  check_pkgs_availability()

}
