% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot-tags.R
\name{spot_tags}
\alias{spot_tags}
\title{Spot Tags}
\usage{
spot_tags(
  file_path = knitr::current_input(),
  used = FALSE,
  drop_knitr = FALSE,
  yaml_bullet = NULL,
  ...
)
}
\arguments{
\item{file_path}{Default is the file being knitted but can change to some
other file (e.g. in cases where the code for the post may reside in a
different file).}

\item{used}{Default is \code{FALSE}. If \code{TRUE} will pass to \code{show_pkgs_used()}
rather than \code{show_pkgs()}. (Mainly useful for showing actual packages used
rather than meta-packages being called like \code{tidyverse} or \code{tidymodels}.
Also uses a more strict parsing method.}

\item{drop_knitr}{Many blogdown posts have \code{knitr::opts_chunk$set()} in them
and you may not want this tag showing-up. Default is to keep this, but set
to \code{FALSE} to drop "knitr" from being tagged.}

\item{yaml_bullet}{Default is \code{NULL} meaning that \code{file_path} is read-in and
correct format is guessed based on "spot_tags" appearance with either a
hyphen or bracket (corresponding with bulleted or array format in the YAML
header).

If it's first occurrence happens on a line that contains a bracket
the value becomes \code{FALSE} else it becomes \code{TRUE}. If set to \code{NULL} and
"spot_tags" is not detected at all in \code{file_path} it will default to
\code{FALSE}. \code{yaml_bullet} can also be specified directly with either \code{TRUE} or
\code{FALSE}. \code{TRUE} entails that \code{spot_tags()} is set in a YAML bullet, \code{FALSE}
indicates the user is inputting it in an array (see examples below).

See examples for how to hard-code.}

\item{...}{Any additional arguments to pass to \verb{spot_pkgs*()}.}
}
\value{
Character vector in a format meant to be read while evaluating the
YAML header when rendering.
}
\description{
Put quoted inline R function in your blogdown or quarto post's YAML header to
have the packages be the packages used in your post (wrapper around
\code{funspotr::spot_pkgs()}).
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{tags:
  - "`r funspotr::spot_tags()`"
}\if{html}{\out{</div>}}

OR

\if{html}{\out{<div class="sourceCode">}}\preformatted{tags: ["`r funspotr::spot_tags()`"]
}\if{html}{\out{</div>}}

OR

\if{html}{\out{<div class="sourceCode">}}\preformatted{categories: ["`r funspotr::spot_tags()`"]
}\if{html}{\out{</div>}}

Thanks Yihui for the suggestions and for getting this working
\href{https://github.com/rstudio/blogdown/issues/647}{blogdown#647}, \href{https://github.com/rstudio/blogdown/issues/693}{blogdown#693}.)
}
\examples{

# To review input interactively from within rstudio you might also try:
\dontrun{
funspotr::spot_tags(rstudioapi::getSourceEditorContext()$path)
}
}
\seealso{
\code{\link[=spot_pkgs]{spot_pkgs()}}, \code{\link[=spot_pkgs_used]{spot_pkgs_used()}}
}
