% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableX.R
\name{tableX}
\alias{tableX}
\title{Table X (for Cross-Tabs)}
\usage{
tableX(.data, x1, x2, type = "count", na.rm = FALSE, format_number = FALSE)
}
\arguments{
\item{.data}{the data frame containing the variables}

\item{x1}{the first bare (not quoted) variable found in .data}

\item{x2}{the second bare (not quoted) variable found in .data}

\item{type}{the summarized output type; can be "count", "cell_perc", "row_perc", or "col_perc"}

\item{na.rm}{logical; whether missing values should be removed}

\item{format_number}{default is FALSE; if TRUE, then the numbers are formatted with commas (e.g., 20,000 instead of 20000)}
}
\description{
Provides a pipe-able, clean, flexible version of \code{table()}.
}
\examples{

\dontrun{

library(furniture)
library(tidyverse)

data <- data.frame(
  x = sample(c(1,2,3,4), 100, replace=TRUE),
  y = sample(c(0,1), 100, replace=TRUE)
)

tableX(data, x, y)

data \%>\%
  tableX(x, y)

data \%>\%
  tableX(x, y, na.rm = TRUE)

}

}
