% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LeveneTest.R
\name{leveneTests_per_SNP}
\alias{leveneTests_per_SNP}
\title{Levene's test for variance homogeneity by SNP genotypes (sex-specific p-values)}
\usage{
leveneTests_per_SNP(
  geno_one,
  SEX = NULL,
  Y,
  centre = "median",
  transformed = TRUE
)
}
\arguments{
\item{geno_one}{the genotype of a bi-allelic SNP, must be a vector of 0, 1, 2's coded for the number of reference allele. Alternatively, for imputed genotypes, it could be a matrix/vector of dosage values, numerically between 0 and 2. The length/dimension of \code{geno_one} should match that of \code{Y}, and/or \code{SEX} and \code{COVAR}.}

\item{SEX}{optional: the genetic sex of individuals in the sample population, must be a vector of 1 and 2 following the default sex code is 1 for males and 2 for females in PLINK.}

\item{Y}{a vector of quantitative traits, such as human height.}

\item{centre}{a character indicating whether the absolute deviation should be calculated with respect to "median" or "mean", the default option is "median".}

\item{transformed}{a logical indicating whether the quantitative response \code{Y} should be transformed using a rank-based method to resemble a normal distribution; recommended for traits with non-symmetric distribution. The default option is \code{TRUE}.}
}
\value{
a vector of Levene's test p-values according to levels specified by \code{geno_one} in each sex and the Fisher's method to combine the sex-specific Levene's test \emph{p}-values.
}
\description{
This function takes as input the genotype of a SNP (\code{geno_one}), the genetic sex (\code{SEX}), a quantitative trait (\code{Y}) in a sample population. The function then returns the variance heterogeneity \emph{p}-values for each sex and the overall variance heterogeneity signal using Fisher's method by combining the sex-specific results.
}
\note{
We recommend to quantile-normally transform \code{Y} to avoid ‘scale-effect’ where
the variance values tend to be proportional to mean values when stratified by \code{G}.
}
\examples{
N <- 5000
sex <- rbinom(N, 1, 0.5)+1
genDAT <- rbinom(N, 2, 0.3)
y <- rnorm(N);

genDAT[sex==2] <- rbinom(sum(sex==2), 1, 0.3)
table(genDAT, sex)
leveneTests_per_SNP(geno_one=genDAT, SEX=sex, Y=y^2, transform=TRUE)

genDAT[sex==2] <- rbinom(sum(sex==2), 1, 0.01)
table(genDAT, sex)
leveneTests_per_SNP(geno_one=genDAT, SEX=sex, Y=y^2, transform=FALSE)

leveneTests_per_SNP(geno_one=rep(0, N), SEX=sex, Y=y^2, transform=TRUE)
leveneTests_per_SNP(geno_one=rep(0, N), Y=y^2, transform=TRUE)


}
\references{
Levene H. (1960) Robust tests for equality of variances. In \emph{Contributions to Probability and Statistics: Essays in Honor of Harold Hotelling} eds:I. Olkin, S.G. Ghurye, W. Hoeffding, W.G. Madow & H.B.Mann, pp.278-292. Stanford: Stanford University Press.
}
\author{
Wei Q. Deng \email{deng@utstat.toronto.edu}, Lei Sun \email{sun@utstat.toronto.edu}
}
