% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/signal_integrate.R
\docType{methods}
\name{signal_integrate}
\alias{signal_integrate}
\alias{signal_integrate-method}
\alias{signal_integrate,GammaSpectrum,missing-method}
\alias{signal_integrate,GammaSpectrum,GammaSpectrum-method}
\alias{signal_integrate,GammaSpectrum,numeric-method}
\alias{signal_integrate,GammaSpectra,missing-method}
\alias{signal_integrate,GammaSpectra,GammaSpectrum-method}
\alias{signal_integrate,GammaSpectra,numeric-method}
\title{Signal Integration}
\usage{
signal_integrate(object, background, ...)

\S4method{signal_integrate}{GammaSpectrum,missing}(object, range = NULL, energy = FALSE)

\S4method{signal_integrate}{GammaSpectrum,GammaSpectrum}(object, background, range = NULL, energy = FALSE)

\S4method{signal_integrate}{GammaSpectrum,numeric}(object, background, range = NULL, energy = FALSE)

\S4method{signal_integrate}{GammaSpectra,missing}(object, range = NULL, energy = FALSE, simplify = TRUE)

\S4method{signal_integrate}{GammaSpectra,GammaSpectrum}(
  object,
  background,
  range = NULL,
  energy = FALSE,
  simplify = TRUE
)

\S4method{signal_integrate}{GammaSpectra,numeric}(
  object,
  background,
  range = NULL,
  energy = FALSE,
  simplify = TRUE
)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectrum} or \linkS4class{GammaSpectra} object.}

\item{background}{A \linkS4class{GammaSpectrum} object.}

\item{...}{Currently not used.}

\item{range}{A length-two \code{\link{numeric}} vector giving the energy range to
integrate within (in keV).}

\item{energy}{A \code{\link{logical}} scalar: use the energy or count threshold for the signal integration}

\item{simplify}{A \code{\link{logical}} scalar: should the result be simplified to a
\code{\link{matrix}}? The default value, \code{FALSE}, returns a \code{\link{list}}.}
}
\value{
If \code{simplify} is \code{FALSE} (the default) returns a \code{\link{list}} of numeric vectors
(the signal value and its error), else returns a \code{\link{matrix}}.
}
\description{
Integration of the spectrum including uncertainty calculation.
}
\details{
The function supports two integration techniques (see Guérin & Mercier 2011),
the (1) count threshold integration and the (2) energy integration method:

The count integration technique (\code{energy = FALSE}) integrates
all counts in given \code{range}:

\deqn{
   A = \frac{\Sigma_{i}^{N}S_i}{t_{live}}
 }

Contrary, the energy integration techniques is the integrated cross-product
of counts and corresponding energy per channel:

\deqn{
  A = \frac{\Sigma_{i}^{N}S_i \times E_i}{t_{live}}
 }

\eqn{A} is the area, \eqn{S_i} is the signal in the \eqn{i^{th}} channel,
\eqn{N} the number of channels, \eqn{E_i} the energy of the corresponding
channel in keV. \eqn{t_{live}} is the live time of the measurement in \emph{s}.

For calculating the uncertainties, Poisson statistics are assumed and hence
the errors is calculated as:

\deqn{
 \sigma_A = \frac{\sqrt{A}}{t_{live}}
 }
}
\note{
The integration assumes that each spectrum has an energy scale.
}
\references{
Guérin, G. & Mercier, M. (2011). Determining Gamma Dose Rates by Field Gamma
Spectroscopy in Sedimentary Media: Results of Monte Carlo Simulations.
\emph{Radiation Measurements}, 46(2), p. 190-195.
\doi{10.1016/j.radmeas.2010.10.003}.

Mercier, N. & Falguères, C. (2007). Field Gamma Dose-Rate Measurement with
a NaI(Tl) Detector: Re-Evaluation of the "Threshold" Technique.
\emph{Ancient TL}, 25(1), p. 1-4.
}
\seealso{
Other signal processing: 
\code{\link{baseline}},
\code{\link{peaks_find}()},
\code{\link{peaks_search}()},
\code{\link{signal_slice}()},
\code{\link{signal_split}()},
\code{\link{signal_stabilize}()},
\code{\link{smooth}()}
}
\author{
N. Frerebeau
}
\concept{signal processing}
