% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_6800.R
\name{read_6800_xlsx}
\alias{read_6800_xlsx}
\title{Reads 6800 xlsx files and creates a tibble with gas-exchange data.}
\usage{
read_6800_xlsx(filename, recalculate = TRUE)
}
\arguments{
\item{filename}{an xlsx file containing 6800 gas-exchange data.}

\item{recalculate}{character string indicating whether or not to recalculate
data using equations from the xlsx file.}
}
\value{
A tibble with gas-exchange data in columns.
}
\description{
The xlsx files stored by the 6800 contain measured and calculated values that
are read by this function and formatted in a large tibble for use with R.
Constants and metadata (such as calibration information) are also added as
columns.
}
\details{
Note that values for many derived gas-exchange parameters are not
stored in the files, but are calculated by equations stored in the xlsx.
These values are 0 after importing, unless setting recalculate = TRUE. It is
also possible to calculate this parameters after importing using the
\code{\link[=recalculate]{recalculate()}} function.

Multiple files can be loaded by calling the function with \code{\link[=lapply]{lapply()}} or
\code{\link[purrr:map]{purrr::map()}} to merge multiple files. In this case, it is important
to ensure that the column names will match. Recalculation can be disabled
for speed, and instead applied to the merged data using \code{\link[=recalculate]{recalculate()}}.
}
\examples{
exampledir <- system.file("extdata", package = "gasanalyzer")
# import factory calibration for example data:
import_factory_cals(exampledir)

# read data:
li6800 <- read_6800_xlsx(file.path(exampledir, "lowo2.xlsx"))
li6800_norecalc <- read_6800_xlsx(file.path(exampledir, "lowo2.xlsx"),
  recalculate = FALSE)
li6800_norecalc$gasanalyzer.Equations <-
  list(read_6800_equations(file.path(exampledir, "lowo2.xlsx")))

all.equal(li6800, recalculate(li6800_norecalc), check.attributes = FALSE)


}
\seealso{
\code{\link[=recalculate]{recalculate()}}
}
